<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
 xmlns="http://www.w3.org/1999/xhtml"
 xmlns:repo="http://eagle-i.org/xsd/repo/"
 xmlns:xhtml="http://www.w3.org/1999/xhtml"
 xmlns:xml="http://www.w3.org/XML/1998/namespace"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:param name="__repo_version" select="'1.0'"/>
  <xsl:param name="__repo_css" select="'/repository/styles/repository.css'"/>
  <xsl:param name="__repo_logo" select="'(Need to set the __repo_logo parameter)'"/>
  <xsl:param name="__repo_title" select="'(Need to set the __repo_title parameter)'"/>
  <xsl:param name="__repo_javascript1" select="'/repository/js/repository-depend.js'"/>
  <xsl:param name="__repo_javascript2" select="'/repository/js/repository.js'"/>
  <xsl:variable name="label" select="/repo:instance/repo:resource/text()"/>
  <xsl:variable name="uri" select="/repo:instance/repo:resource/@uri"/>
  <xsl:template match="/repo:instance">
    <html>
    <head>
    <meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
    <meta name="eaglei.version">
    <xsl:attribute name="content"><xsl:value-of select="$__repo_version"/></xsl:attribute>
    </meta>
    <title><xsl:value-of select="$label"/></title>
    <meta name="eaglei.repository.title">
    <xsl:attribute name="content"><xsl:value-of select="$__repo_title"/></xsl:attribute>
    </meta>
    <link rel="stylesheet" type="text/css" href="/repository/styles/repository.css" />
    <script language="javascript" type="text/javascript" src="/repository/js/repository-depend.js"></script>
    <script language="javascript" type="text/javascript" src="/repository/js/repository.js"></script>
    </head>
    <body>






    <div id="header">
      <div id="wrapper">
        <div id="logo_datatools">
        	<img src="/repository/images/eagle-i_logo2.png" alt="" width="264" height="115" align="middle" /> at 
        	<img border="0" align="middle" hspace="5">
                <xsl:attribute name="src"> 
                    <xsl:value-of select="$__repo_logo"/> 
                </xsl:attribute>
                <xsl:attribute name="alt"> 
                    <xsl:value-of select="$__repo_title"/> 
                </xsl:attribute>
            </img> <xsl:value-of select="$__repo_title"/>
        </div>
      </div>
    </div>
    
    
    <div id="wrapper">
      <div id="wrapper">
        <div id="datatoolsWrapper">
          <div id="datatoolsContent2">
            <div class="leftPanel">
              <div class="contactSidebarComponent" style="width: 180px;">
                <a  class="contactButton" id="contactButton">
                    <xsl:attribute name="href"> 
                    	<xsl:value-of select="concat('/repository/contact?uri=',$uri)"/> 
                    </xsl:attribute>
                    Contact the owner of this resource! </a>
              </div>
            </div>
            <div class="dataPanel">
              <div id="staticContent">
                <h2 class="eaglei_resourceLabel"><xsl:value-of select="$label"/></h2>
                <h3 class="eaglei_resourceTypes">Resource</h3>
                <div class="eaglei_resourceType"><xsl:value-of select="$uri"/></div>
                <h3 class="eaglei_resourceTypes">Direct Types</h3>
                <div>
                	<ol class="propertyList">
                		<xsl:apply-templates select="repo:asserted-types/*" mode="typeList"/>
                	</ol>
                </div>
                <h3 class="eaglei_resourceProperties">Properties</h3>
                	<ol class="propertyList">
                		<xsl:apply-templates select="repo:properties/*" mode="propertyList"/>
                	</ol>
                <div class="clearBoth"></div>
                <div class="expandBox">
                  <div class="expandBoxTitle"><a href="javascript:hideShowBox('inferedBox');"><img src="/repository/images/drop_arrow.png" width="16" height="16" alt="arrow" border="0" />Inferred Types</a></div>
                  <div id="inferedBox" style="display:none;">
                    <ol class="propertyList">
      					<xsl:apply-templates select="repo:inferred-types/*" mode="typeList"/>
                    </ol>
                  </div>
                </div>
                <div class="expandBox">
                  <div class="expandBoxTitle"><a href="javascript:hideShowBox('metadataBox');"><img src="/repository/images/drop_arrow.png" width="16" height="16" alt="arrow" border="0" />Provenance Metadata</a></div>
                  <div id="metadataBox" style="display:none;">
                    <ol class="propertyList">
      					<xsl:apply-templates select="repo:metadata/*" mode="propertyList"/>
                    </ol>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

  <div id="bottomRow">
    <div id="bottomRowRight">Making Invisible Resources <span class="bolder">Visible</span></div>
    <div id="bottomRowLeft"><a href="https://www.eagle-i.org/about/" target="_blank">About Us</a> <span class="barSpacing">|</span> <a href="https://www.eagle-i.org/contact/" target="_blank">Contact</a> <span class="barSpacing">|</span> <a href="http://www.eagle-i.org/home" target="_blank">www.eagle-i.org</a></div>
  </div>
  <div id="bottomLegal" style="clear:both">The eagle-i Consortium Supported by NIH Grant # U24-1U24RR029825-01<br />
    Copyright 2011</div>
    </div>
    
    
    
    
    <!-- links to edit and/or mung rights -->
    <xsl:apply-templates select="repo:permission"/>
    
    </body>
    </html>
  </xsl:template>
  <xsl:template match="repo:resource" mode="typeList">
    <li>
      <xsl:apply-templates select="."/>
    </li>
  </xsl:template>
  <xsl:template match="repo:property" mode="propertyList">
    <li>
      <xsl:apply-templates select="."/>
    </li>
  </xsl:template>
  <xsl:template match="repo:property">
    <dl>
      <dt>
        <xsl:apply-templates select="repo:predicate/*"/>
      </dt>
      <dd>
        <xsl:apply-templates select="repo:object/*"/>
      </dd>
    </dl>
  </xsl:template>
  <!-- General rendering of Resource: make a link out of it -->
  <xsl:template match="repo:resource">
    <a>
    <xsl:attribute name="href"><xsl:value-of select="@uri"/></xsl:attribute>
    <xsl:value-of select="text()"/></a>
  </xsl:template>
  <!-- Render a Literal
       1. if it is a URL (type == xsd:anyURI), show it as a link
          (could optionally check for starting with "http(s?):")
       2. otherwise show as text, passing through any xml:lang attribute.
   -->
  <xsl:template match="repo:literal">
    <xsl:choose>
      <xsl:when test="@type = 'http://www.w3.org/2001/XMLSchema#anyURI'">
        <a>
        <xsl:attribute name="href"><xsl:value-of select="text()"/></xsl:attribute>
        <xsl:value-of select="text()"/></a>
      </xsl:when>
      <xsl:otherwise>
        <span>
        <xsl:if test="@xml:lang">
          <xsl:attribute name="xml:lang"><xsl:value-of select="@xml:lang"/></xsl:attribute>
        </xsl:if>
        <xsl:value-of select="text()"/></span>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- links to edit and/or mung rights -->
  <xsl:template match="repo:permission">
    <xsl:if test="@admin = 'true'">
      <form method="POST" action="/repository/admin/editGrants.jsp">
        <input type="hidden" name="type" value="Resource Instance" />
        <input type="hidden" name="uri">
        <xsl:attribute name="value"><xsl:value-of select="$uri"/></xsl:attribute>
        </input>
        <input type="hidden" name="label">
        <xsl:attribute name="value"><xsl:value-of select="$label"/></xsl:attribute>
        </input>
        <button type="submit">Edit Access Controls</button>
      </form>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
