<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML+RDFa 1.0//EN" "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"
      xmlns:dc="http://purl.org/dc/elements/1.1/"
      lang="en"
      xml:lang="en">
<%--
   -  Display application version for users and as RDFa
   -
   -  This sets standard DC (Dublin Core Element Set) properties
   -  although the meaning is somewhat dubious; it is valid enough
   -  to ues this interpretation within eaglei and have *some* meaning
   -  in the outside world too.  Unfortunately the DC properties were
   -  intended as library metadata so there aren't really any good choices.
   -
   -   dc:date - the build date/time
   -   dc:source - the SCM version number
   -   dc:description - the Maven package version
   -
   - $Id$
  --%>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.eaglei.repository.Configuration" %>
<%@ page import="org.eaglei.repository.util.Utils" %>
<%
    String mavenVersion = Configuration.getInstance().getProjectVersion();
    String buildTime = Configuration.getInstance().getTimestamp();
    String scmVersion = Configuration.getInstance().getRevision();
    String scmBranch = Configuration.getInstance().getBranch();
    String about = request.getRequestURL().toString();
    String sesameVersion = Configuration.getInstance().getSesameVersion();
 %>
  <head about="<%= Utils.escapeHTMLAttribute(about) %>">
    <%@ include file="../head.jsp" %>
    <meta property="dc:description" content="<%= Utils.escapeHTMLAttribute(mavenVersion) %>" />
    <meta property="dc:date" content="<%= Utils.escapeHTMLAttribute(buildTime) %>" />
    <meta property="dc:source" content="<%= Utils.escapeHTMLAttribute(scmVersion) %>" />
    <title>Eagle-I Repository Version</title>
  </head>
  <body about="<%= Utils.escapeHTMLAttribute(about) %>">
    <h1>Eagle-i Data Repository Version Information</h1>
    <dl>
      <dt>Maven package version</dt>
      <dd><tt property="dc:description"><%= StringEscapeUtils.escapeHtml(mavenVersion) %></tt></dd>
      <dt>Build time</dt>
      <dd><tt property="dc:date"><%= StringEscapeUtils.escapeHtml(buildTime) %></tt></dd>
      <dt>SCM Branch</dt>
      <dd><tt property="dc:source"><%= scmBranch == null ? "trunk" : StringEscapeUtils.escapeHtml(scmBranch) %></tt></dd>
      <dt>SCM revision</dt>
      <dd><tt property="dc:source"><%= StringEscapeUtils.escapeHtml(scmVersion) %></tt></dd>
      <dt>OpenRDF Sesame Version</dt>
      <dd><tt property="dc:source"><%= sesameVersion %></tt></dd>
    </dl>
  </body>
</html>
