/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.eaglei.repository.DCTERMS;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Utils;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.openrdf.sail.nativerdf.NativeStore;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataRepositoryLifecycle
implements ServletContextListener {
    private static Logger log = LogManager.getLogger(DataRepositoryLifecycle.class);
    private static final String SCTX_REPOSITORY = "org.eaglei.repository.SesameRepository";
    private static final String SCTX_GENERATION = "org.eaglei.repository.Generation";
    private static final String CONFIG_NAMESPACE = "eaglei.repository.namespace";
    private static final String CONFIG_LOGDIR = "eaglei.repository.log.dir";
    private static final String CONFIG_SESAMEDIR = "eaglei.repository.sesame.dir";
    private static ServletContext currentContext = null;
    private static Configuration configuration = null;
    static String namespaceDefault = null;
    private static Properties buildProperties;

    private static void printError(String msg) {
        System.err.println("***ERROR*** (at " + new Date().toString() + ") eagle-i DataRepositoryLifecycle: " + msg);
    }

    private static void printInfo(String msg) {
        System.err.println("***INFO*** (at " + new Date().toString() + ") eagle-i DataRepositoryLifecycle: " + msg);
    }

    private void setupDefaultLogging(File home) throws IOException {
        String logPath = configuration.getString("eaglei.repository.log.dir");
        File logDir = logPath == null ? new File(home, "logs") : new File(logPath);
        DataRepositoryLifecycle.printInfo((String)("Log file directory configured as: " + logDir.toString()));
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        RollingFileAppender a = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601} %p %c - %m%n"), new File(logDir, "default.log").toString());
        a.setName("default");
        BasicConfigurator.configure((Appender)a);
        Logger.getRootLogger().setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIfEmpty(Repository r, URI graphURI, String resourcePath) throws RepositoryException, IOException, RDFParseException {
        RepositoryConnection rc = null;
        try {
            rc = r.getConnection();
            ValueFactory vf = r.getValueFactory();
            if (rc.size(new Resource[]{graphURI}) == 0L) {
                URL rurl = currentContext.getResource(resourcePath);
                if (rurl == null) {
                    log.error((Object)("Cannot find webapp resource at path=" + resourcePath));
                } else {
                    URLConnection ruc = rurl.openConnection();
                    long rdate = ruc.getLastModified();
                    log.debug((Object)("Loading graph=" + graphURI.toString() + " from URL=" + rurl.toString() + ", mod-date=" + rdate));
                    InputStreamReader is = new InputStreamReader(ruc.getInputStream());
                    if (is == null) {
                        log.error((Object)("Cannot open webapp resource at url=" + rurl));
                    } else {
                        rc.add((Reader)is, graphURI.toString(), RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3), new Resource[]{graphURI});
                        Literal when = Provenance.getDateTime((Date)new Date(rdate));
                        Provenance.setProvenance((RepositoryConnection)rc, (Resource)graphURI, (URI)DCTERMS.CREATED, (Value)when);
                        Provenance.setProvenance((RepositoryConnection)rc, (Resource)graphURI, (URI)DCTERMS.CREATOR, (Value)REPO.ROLE_SUPERUSER);
                        Provenance.setSource((RepositoryConnection)rc, (Resource)graphURI, (Value)rc.getValueFactory().createURI(rurl.toString()), (Value)when);
                        rc.commit();
                        log.info((Object)("Initialized the empty named graph, name=" + graphURI + ", with resource path=" + resourcePath));
                    }
                }
            }
        }
        finally {
            if (rc != null) {
                rc.close();
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        currentContext = sce.getServletContext();
        try {
            File sesDir;
            File pf;
            File home = Utils.getHomeDirectory();
            DataRepositoryLifecycle.printInfo((String)("Configuring with Eagle-I Repository Home dir = " + home.toString()));
            if (!home.exists()) {
                if (!home.mkdirs()) {
                    DataRepositoryLifecycle.printError((String)("Failed to create repository home directory, configured path = " + home));
                    DataRepositoryLifecycle.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
                }
            } else if (!home.isDirectory()) {
                DataRepositoryLifecycle.printError((String)("Path configured as repository home is not a directory: " + home));
                DataRepositoryLifecycle.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
            }
            if (!(pf = new File(home, "configuration.properties")).exists()) {
                try {
                    Utils.copyStream((InputStream)currentContext.getResourceAsStream("/WEB-INF/classes/default.configuration.properties"), (OutputStream)new FileOutputStream(pf));
                }
                catch (IOException e) {
                    try {
                        pf.delete();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    DataRepositoryLifecycle.printError((String)("Failed to copy default configuration file to repository home dir: " + e));
                }
            }
            try {
                log.debug((Object)("Loading configuration from file=" + pf));
                configuration = new PropertiesConfiguration(pf);
            }
            catch (Exception e) {
                DataRepositoryLifecycle.printError((String)("Failed to read configuration, file=" + pf + ": " + e.toString()));
            }
            Properties lp = new Properties();
            Iterator pi = configuration.getKeys("log4j");
            while (pi.hasNext()) {
                String k = (String)pi.next();
                lp.setProperty(k, configuration.getString(k));
            }
            if (lp.containsKey("log4j.rootLogger")) {
                DataRepositoryLifecycle.printInfo((String)"Setting up log4j with existing configuration properties");
                PropertyConfigurator.configure((Properties)lp);
            } else {
                DataRepositoryLifecycle.printInfo((String)("Using default log4j setup, additional property count = " + lp.size()));
                this.setupDefaultLogging(home);
                if (lp.size() > 0) {
                    PropertyConfigurator.configure((Properties)lp);
                }
            }
            String sesPath = configuration.getString("eaglei.repository.sesame.dir");
            File file = sesDir = sesPath == null ? new File(home, "sesame") : new File(sesPath);
            if (!sesDir.exists()) {
                sesDir.mkdirs();
            }
            SailRepository r = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new NativeStore(sesDir)));
            r.initialize();
            if (!r.isWritable()) {
                log.fatal((Object)"Sesame repo is not writable, this is going to cause trouble soon!");
            }
            currentContext.setAttribute("org.eaglei.repository.SesameRepository", (Object)r);
            log.info((Object)("Sesame Repository open, directory=" + sesDir.toString()));
            currentContext.setAttribute("org.eaglei.repository.Generation", (Object)new Integer(1));
            log.debug((Object)"Generation initialized to 1.");
            this.loadIfEmpty((Repository)r, REPO.NAMESPACE_URI, "/WEB-INF/classes/repository-ont.n3");
        }
        catch (Exception e) {
            DataRepositoryLifecycle.printError((String)("Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:" + e.toString()));
            log.fatal((Object)"Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        try {
            Repository r = (Repository)ctx.getAttribute("org.eaglei.repository.SesameRepository");
            if (r != null) {
                r.shutDown();
                log.info((Object)"Sesame Repository closed.");
            }
            ctx.removeAttribute("org.eaglei.repository.SesameRepository");
        }
        catch (Exception e) {
            log.error((Object)"Got exception in Webapp context finalization, but forging ahead:", (Throwable)e);
        }
    }

    public static Repository getSesameRepository() throws ServletException {
        Repository result = (Repository)currentContext.getAttribute("org.eaglei.repository.SesameRepository");
        if (result == null) {
            throw new ServletException("No RDF database connection, probably because of a failure in initialization.");
        }
        log.debug((Object)("sesame repository type = " + result.getClass().getName()));
        log.debug((Object)("sesame repository's top SAIL type = " + ((SailRepository)result).getSail().getClass().getName()));
        return result;
    }

    public static String getDefaultNamespace() {
        String result = configuration.getString("eaglei.repository.namespace");
        if (result != null) {
            log.debug((Object)("Default namespace configured=" + result));
            return result;
        }
        log.warn((Object)("No value for config key=eaglei.repository.namespace, using fallback value for default namespace, URI = " + namespaceDefault));
        return namespaceDefault;
    }

    public static String getConfigurationProperty(String key) {
        return configuration.getString(key);
    }

    public static String getConfigurationProperty(String key, String dflt) {
        String result = configuration.getString(key);
        return result == null ? dflt : result;
    }

    public static void incrementGeneration() {
        int gen = 1 + (Integer)currentContext.getAttribute("org.eaglei.repository.Generation");
        currentContext.setAttribute("org.eaglei.repository.Generation", (Object)new Integer(gen));
        log.debug((Object)("Generation is incremented to " + gen));
    }

    public static boolean isSessionStale(HttpSession session) {
        Integer sessionGen = (Integer)session.getAttribute("org.eaglei.repository.Generation");
        Integer ctxGen = (Integer)currentContext.getAttribute("org.eaglei.repository.Generation");
        boolean result = sessionGen != null && sessionGen < ctxGen;
        session.setAttribute("org.eaglei.repository.Generation", (Object)ctxGen);
        return result;
    }

    public static Reader getResourceAsReader(String path) {
        if (currentContext == null) {
            log.error((Object)"getResourceAsStream: currentContext not set!");
            return null;
        }
        return new InputStreamReader(currentContext.getResourceAsStream(path));
    }

    public static String getVersion() {
        return DataRepositoryLifecycle.getBuildProperties().getProperty("version");
    }

    public static String getTimestamp() {
        return DataRepositoryLifecycle.getBuildProperties().getProperty("timestamp");
    }

    private static Properties getBuildProperties() {
        if (buildProperties == null) {
            if (currentContext == null) {
                log.error((Object)"getBuildProperties: currentContext not set!");
                return null;
            }
            buildProperties = new Properties();
            try {
                buildProperties.load(currentContext.getResourceAsStream("/WEB-INF/classes/build.properties"));
            }
            catch (IOException e) {
                log.error((Object)"Failed loading build.properties: ", (Throwable)e);
            }
        }
        return buildProperties;
    }

    static {
        try {
            namespaceDefault = "http://" + InetAddress.getLocalHost().getHostName() + "/i/";
        }
        catch (UnknownHostException e) {
            namespaceDefault = "http://failed-to-get-local-host-name/i/";
        }
        buildProperties = null;
    }
}

