/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DCTERMS;
import org.eaglei.repository.InternalServerErrorException;
import org.eaglei.repository.REPO;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.CalendarLiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Provenance {
    private static Logger log = LogManager.getLogger(Provenance.class);
    public static URI PROVENANCE_GRAPH = REPO.NG_METADATA;
    private static URI[] predicatesArray = new URI[]{DCTERMS.CREATED, DCTERMS.CREATOR, DCTERMS.CONTRIBUTOR, DCTERMS.MODIFIED, DCTERMS.MEDIATOR, DCTERMS.SOURCE, DCTERMS.IDENTIFIER};
    private static Set<URI> predicates = new HashSet();

    public static boolean isProvenancePredicate(URI pp) {
        return predicates.contains(pp);
    }

    public static void setCreated(HttpServletRequest request, Resource what, Literal when) {
        Provenance.setProvenance((HttpServletRequest)request, (Resource)what, (URI)DCTERMS.CREATOR, (URI)DCTERMS.CREATED, (Literal)when);
    }

    public static void setMediated(HttpServletRequest request, Resource what, Literal when) {
        Provenance.setProvenance((HttpServletRequest)request, (Resource)what, (URI)DCTERMS.MEDIATOR, (URI)DCTERMS.CREATED, (Literal)when);
    }

    public static void setModified(HttpServletRequest request, Resource what, Literal when) {
        Provenance.setProvenance((HttpServletRequest)request, (Resource)what, (URI)DCTERMS.CONTRIBUTOR, (URI)DCTERMS.MODIFIED, (Literal)when);
    }

    private static void setProvenance(HttpServletRequest request, Resource what, URI whoTerm, URI whenTerm, Literal when) {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        URI who = Access.getPrincipalURI((HttpServletRequest)request);
        Provenance.setProvenance((RepositoryConnection)rc, (Resource)what, (URI)whoTerm, (Value)who);
        Provenance.setProvenance((RepositoryConnection)rc, (Resource)what, (URI)whenTerm, (Value)when);
    }

    public static void setProvenance(RepositoryConnection rc, Resource what, URI term, Value value) {
        try {
            rc.remove(what, term, null, new Resource[]{PROVENANCE_GRAPH});
            rc.add(what, term, value, new Resource[]{PROVENANCE_GRAPH});
            log.debug((Object)("Setting provenance: (" + what + ", " + term + ", " + value + ")"));
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static void setSource(HttpServletRequest request, Resource what, String source, String sourceModified) {
        if (source == null) {
            return;
        }
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        ValueFactory vf = rc.getValueFactory();
        Provenance.setSource((RepositoryConnection)rc, (Resource)what, (Value)vf.createLiteral(source, XMLSchema.STRING), sourceModified == null ? null : vf.createLiteral(sourceModified, XMLSchema.STRING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSource(RepositoryConnection rc, Resource what, Value source, Value sourceModified) {
        if (source == null) {
            return;
        }
        try {
            if (rc.hasStatement(what, DCTERMS.SOURCE, null, true, new Resource[]{PROVENANCE_GRAPH})) {
                RepositoryResult rr = rc.getStatements(what, DCTERMS.SOURCE, null, true, new Resource[]{PROVENANCE_GRAPH});
                try {
                    while (rr.hasNext()) {
                        Statement s = (Statement)rr.next();
                        Value bn = s.getObject();
                        if (!(bn instanceof Resource)) continue;
                        rc.remove((Resource)bn, null, null, new Resource[]{PROVENANCE_GRAPH});
                    }
                }
                finally {
                    rr.close();
                }
                rc.remove(what, DCTERMS.SOURCE, null, new Resource[]{PROVENANCE_GRAPH});
            }
            BNode bn = rc.getValueFactory().createBNode();
            rc.add((Resource)bn, DCTERMS.IDENTIFIER, source, new Resource[]{PROVENANCE_GRAPH});
            log.debug((Object)("Setting provenance source: (" + what + ", dcterms:source, " + bn + ")"));
            log.debug((Object)("Setting provenance source: (" + bn + ", dcterms:identifier, " + source + ")"));
            if (sourceModified != null) {
                rc.add((Resource)bn, DCTERMS.MODIFIED, sourceModified, new Resource[]{PROVENANCE_GRAPH});
                log.debug((Object)("Setting provenance source: (" + bn + ", dcterms:modified, " + sourceModified + ")"));
            }
            rc.add(what, DCTERMS.SOURCE, (Value)bn, new Resource[]{PROVENANCE_GRAPH});
        }
        catch (RepositoryException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static Literal getCurrentDateTime() {
        return Provenance.getDateTime((Date)new Date());
    }

    public static Literal getDateTime(Date when) {
        try {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(when);
            return new CalendarLiteralImpl(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static {
        for (URI p : predicatesArray) {
            predicates.add(p);
        }
    }
}

