/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Formats;
import org.eaglei.repository.REPO;
import org.eaglei.repository.Utils;
import org.eaglei.repository.Views;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.repository.RepositoryConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQL {
    private static Logger log = LogManager.getLogger(SPARQL.class);
    public static final String PREFIXES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX dcterms: <http://purl.org/dc/terms/>\nPREFIX : <http://eagle-i.org/ont/repo/1.0/>\nPREFIX internal: <http://eagle-i.org/ont/repo/1.0/>\n";
    public static final DatasetImpl InternalGraphs = new DatasetImpl();
    private static DatasetImpl InternalAndMetadataGraphs;
    public static final DatasetImpl InternalGraphsAndInferred;

    public static Dataset getInternalAndMetadataGraphs(HttpServletRequest request) {
        if (InternalAndMetadataGraphs == null) {
            InternalAndMetadataGraphs = SPARQL.copyDataset((Dataset)InternalGraphs);
            Views.addGraphs((HttpServletRequest)request, (DatasetImpl)InternalAndMetadataGraphs, (Views.View)Views.View.METADATA);
        }
        return InternalAndMetadataGraphs;
    }

    public static DatasetImpl copyDataset(Dataset src) {
        DatasetImpl result = new DatasetImpl();
        for (URI dg : src.getDefaultGraphs()) {
            result.addDefaultGraph(dg);
        }
        return result;
    }

    public static void tupleQueryRequest(HttpServletRequest request, HttpServletResponse response, String query, String format, Dataset ds) throws ServletException, IOException {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        log.debug((Object)("Trying SPARQL query = " + query));
        log.debug((Object)("Dataset for SPARQL query = " + Utils.prettyPrint((Dataset)ds)));
        TupleQuery q = null;
        try {
            q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
        }
        catch (MalformedQueryException e) {
            log.info((Object)"Rejecting malformed query.");
            response.sendError(500, "Malformed query was generated internally: " + e.toString());
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        q.setIncludeInferred(true);
        q.setDataset(ds);
        String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml");
        TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
        if (tqf == null) {
            log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
            throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
        }
        response.setContentType(mimeType);
        try {
            q.evaluate((TupleQueryResultHandler)QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream()));
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static void sendTupleQueryResults(HttpServletRequest request, HttpServletResponse response, String format, Iterable<BindingSet> bindings) throws ServletException, IOException {
        String mimeType = Formats.negotiateTupleContent((HttpServletRequest)request, (String)format, (String)"application/sparql-results+xml");
        TupleQueryResultFormat tqf = QueryResultIO.getWriterFormatForMIMEType((String)mimeType);
        if (tqf == null) {
            log.error((Object)("Failed to get tuple query format, for mime=" + mimeType));
            throw new ServletException("Failed to get tuple query format that SHOULD have been available, for mime=" + mimeType);
        }
        response.setContentType(mimeType);
        try {
            TupleQueryResultWriter h = QueryResultIO.createWriter((TupleQueryResultFormat)tqf, (OutputStream)response.getOutputStream());
            Iterator<BindingSet> bi = bindings.iterator();
            if (bi.hasNext()) {
                BindingSet first = bi.next();
                Set bns = first.getBindingNames();
                h.startQueryResult(Arrays.asList(bns.toArray(new String[bns.size()])));
                h.handleSolution(first);
                while (bi.hasNext()) {
                    h.handleSolution(bi.next());
                }
                h.endQueryResult();
            } else {
                h.startQueryResult(new ArrayList(0));
                h.endQueryResult();
            }
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static {
        InternalGraphs.addDefaultGraph(REPO.NAMESPACE_URI);
        InternalGraphs.addDefaultGraph(REPO.NG_INTERNAL);
        InternalAndMetadataGraphs = null;
        InternalGraphsAndInferred = new DatasetImpl();
        InternalGraphsAndInferred.addDefaultGraph(REPO.NAMESPACE_URI);
        InternalGraphsAndInferred.addDefaultGraph(REPO.NG_INTERNAL);
        InternalGraphsAndInferred.addDefaultGraph(null);
    }
}

