/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.DataRepositoryLifecycle;
import org.eaglei.repository.Formats;
import org.eaglei.repository.NotFoundException;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.REPO;
import org.eaglei.repository.servlet.Graph;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.util.RDFRemover;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public class Graph
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(Graph.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = null;
        String action = null;
        String format = null;
        String contentType = null;
        String remoteURI = null;
        String source = null;
        String sourceModified = null;
        String type = null;
        Reader content = null;
        boolean all = false;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("name")) {
                        name = item.getString();
                        continue;
                    }
                    if (ifn.equals("all")) {
                        all = true;
                        continue;
                    }
                    if (ifn.equals("action")) {
                        action = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    if (ifn.equals("type")) {
                        type = item.getString();
                        continue;
                    }
                    if (ifn.equals("uri")) {
                        remoteURI = item.getString();
                        continue;
                    }
                    if (ifn.equals("content")) {
                        FileItemHeaders hd;
                        content = new InputStreamReader(item.getInputStream());
                        contentType = item.getContentType();
                        if (source == null) {
                            source = item.getName();
                        }
                        if ((hd = item.getHeaders()) != null && sourceModified == null) {
                            sourceModified = hd.getHeader("Last-Modified");
                        }
                        log.debug((Object)("Got content stream, MIME type = " + contentType));
                        continue;
                    }
                    if (ifn.equals("source")) {
                        source = item.getString();
                        continue;
                    }
                    if (ifn.equals("sourceModified")) {
                        sourceModified = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                response.sendError(400, "failed parsing multipart request");
                return;
            }
        } else {
            name = request.getParameter("name");
            all = request.getParameter("all") != null;
            action = request.getParameter("action");
            format = request.getParameter("format");
            type = request.getParameter("type");
            remoteURI = request.getParameter("uri");
            String cs = request.getParameter("content");
            if (cs != null) {
                content = new StringReader(cs);
            }
            source = request.getParameter("source");
            sourceModified = request.getParameter("sourceModified");
        }
        if (format == null) {
            format = contentType;
        }
        this.putGraphInternal(request, response, name, all, action, format, remoteURI, content, source, sourceModified, type);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        String action = request.getParameter("action");
        String format = request.getParameter("format");
        if (format == null) {
            format = request.getContentType();
        }
        String remoteURI = request.getParameter("uri");
        boolean all = request.getParameter("all") != null;
        String source = request.getParameter("source");
        String type = request.getParameter("type");
        String sourceModified = request.getParameter("sourceModified");
        if (sourceModified == null) {
            sourceModified = request.getHeader("Last-Modified");
        }
        this.putGraphInternal(request, response, name, all, action, format, remoteURI, (Reader)new InputStreamReader((InputStream)request.getInputStream()), source, sourceModified, type);
    }

    private void putGraphInternal(HttpServletRequest request, HttpServletResponse response, String name, boolean all, String rawAction, String rawFormat, String remoteURI, Reader content, String source, String sourceModified, String type) throws ServletException, IOException {
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        ValueFactory vf = rc.getValueFactory();
        Action action = null;
        if (rawAction == null) {
            response.sendError(400, "Missing required argument: action");
            return;
        }
        for (Action a : Action.values()) {
            if (!a.name().equalsIgnoreCase(rawAction)) continue;
            action = a;
            break;
        }
        if (action == null) {
            response.sendError(400, "Action argument must match one of the following keywords: " + Arrays.deepToString(Action.values()));
            return;
        }
        log.debug((Object)("Argument action = " + action));
        if (rawFormat == null) {
            response.sendError(400, "Missing required argument: format (or content-type)");
            return;
        }
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)rawFormat);
        if (format == null) {
            response.sendError(415, "MIME type of serialized RDF is not supported: \"" + rawFormat + "\"");
            return;
        }
        log.debug((Object)("Argument format = " + format));
        if (all && name != null) {
            response.sendError(400, "You may not specify both a named graph and the 'all' keyword");
            return;
        }
        if (!all && name == null) {
            response.sendError(400, "Missing required argument: name");
            return;
        }
        URI graphName = null;
        if (name != null) {
            try {
                graphName = vf.createURI(name);
                log.debug((Object)("Argument graph name = " + graphName));
            }
            catch (IllegalArgumentException e) {
                response.sendError(400, "Graph name URI was badly formed: " + e.toString());
                return;
            }
        }
        if (all && !format.supportsContexts()) {
            response.sendError(400, "'All' may not be specified with a format that does not support quads");
            return;
        }
        if (remoteURI == null && content == null) {
            response.sendError(400, "No input source, either remote URI or content must be specified");
            return;
        }
        if (remoteURI != null) {
            response.sendError(501, "Not accepting graphs from remote URLs yet.");
            return;
        }
        URI ngType = null;
        if (!all && type != null) {
            REPO.NGType t = REPO.NGType.parse((String)type);
            if (t == null) {
                response.sendError(400, "Named graph type \"" + type + "\" does not match any of the defined types: " + Arrays.deepToString(REPO.NGType.values()));
                return;
            }
            ngType = t.uri;
        }
        if (all && Access.isSuperuser((HttpServletRequest)request) || graphName != null && (action != Action.ADD && action != Action.REPLACE || Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (URI)REPO.NAMED_GRAPH, (Access)Access.ADD)) && (action != Action.DELETE && action != Action.REPLACE || Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (URI)REPO.NAMED_GRAPH, (Access)Access.REMOVE))) {
            try {
                long before;
                boolean created;
                boolean bl = created = action == Action.REPLACE || action == Action.ADD && !all && rc.size(new Resource[]{graphName}) == 0L;
                if (action == Action.ADD || action == Action.REPLACE) {
                    if (action == Action.REPLACE) {
                        if (all) {
                            rc.clear(new Resource[0]);
                            DataRepositoryLifecycle.incrementGeneration();
                        } else {
                            rc.clear(new Resource[]{graphName});
                        }
                    }
                    if (all) {
                        before = rc.size(new Resource[0]);
                        rc.add(content, "", format, new Resource[0]);
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[0]) - before) + " statements to all graphs."));
                    } else {
                        before = rc.size(new Resource[]{graphName});
                        rc.add(content, "", format, new Resource[]{graphName});
                        log.info((Object)("Added " + String.valueOf(rc.size(new Resource[]{graphName}) - before) + " statements to graph:" + graphName.toString()));
                    }
                    if (!all && !rc.hasStatement((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                        rc.add((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, new Resource[]{REPO.NG_INTERNAL});
                        log.debug((Object)("Declaring rdf:type of named graph URI = " + graphName));
                    }
                    if (!all && ngType != null && !rc.hasStatement((Resource)graphName, REPO.NG_TYPE, (Value)ngType, true, new Resource[]{REPO.NG_INTERNAL})) {
                        rc.remove((Resource)graphName, REPO.NG_TYPE, null, new Resource[]{REPO.NG_INTERNAL});
                        rc.add((Resource)graphName, REPO.NG_TYPE, (Value)ngType, new Resource[]{REPO.NG_INTERNAL});
                        log.debug((Object)("Setting ngType of named graph = " + graphName + ", type=" + ngType));
                    }
                } else if (action == Action.DELETE) {
                    before = rc.size(new Resource[]{graphName});
                    RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)vf);
                    RDFRemover rr = new RDFRemover(rc);
                    if (!all) {
                        rr.enforceContext((Resource)graphName);
                    }
                    parser.setRDFHandler((RDFHandler)rr);
                    parser.parse(content, "");
                    log.info((Object)("Deleted " + String.valueOf(before - rc.size(new Resource[]{graphName})) + " statements to graph:" + graphName.toString()));
                }
                if (!all) {
                    Literal now = Provenance.getCurrentDateTime();
                    if (created) {
                        Provenance.setCreated((HttpServletRequest)request, (Resource)graphName, (Literal)now);
                    }
                    Provenance.setModified((HttpServletRequest)request, (Resource)graphName, (Literal)now);
                    if (source != null) {
                        Provenance.setSource((HttpServletRequest)request, (Resource)graphName, (String)source, (String)sourceModified);
                    }
                }
                rc.commit();
                response.setStatus(created ? 201 : 200);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed parsing user-supplied graph content: ", (Throwable)e);
                throw new BadRequestException((Throwable)e);
            }
        } else {
            response.sendError(403, "User is not permitted to " + action + " this graph");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean all;
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute("org.eaglei.repository.RepositoryConnection");
        ValueFactory vf = rc.getValueFactory();
        String mimeType = Formats.negotiateRDFContent((HttpServletRequest)request, (String)request.getParameter("format"), (String)"application/rdf+xml");
        RDFFormat format = Formats.RDFOutputFormatForMIMEType((String)mimeType);
        if (format == null) {
            response.sendError(400, "Unrecognized MIME type for serialized RDF format: \"" + mimeType + "\"");
            return;
        }
        log.debug((Object)("Negotiated output format = " + format));
        boolean force = request.getParameter("force") != null;
        String name = request.getParameter("name");
        boolean bl = all = request.getParameter("all") != null;
        if (all && name != null) {
            response.sendError(400, "You may not specify both a named graph and the 'all' keyword");
            return;
        }
        if (!all && name == null) {
            response.sendError(400, "Missing required argument: name");
            return;
        }
        if (all && !format.supportsContexts() && !force) {
            response.sendError(400, "'All' may not be specified with a format that does not support quads");
            return;
        }
        URI graphName = null;
        if (name != null) {
            try {
                graphName = vf.createURI(name);
            }
            catch (IllegalArgumentException e) {
                response.sendError(400, "Graph name URI was badly formed: " + e.toString());
                return;
            }
        }
        log.debug((Object)("Argument graph name = " + graphName));
        if (all && Access.isSuperuser((HttpServletRequest)request) || graphName != null && Access.hasPermission((HttpServletRequest)request, (Resource)graphName, (URI)REPO.NAMED_GRAPH, (Access)Access.READ)) {
            response.setContentType(format.getDefaultMIMEType());
            try {
                if (all) {
                    rc.export((RDFHandler)Rio.createWriter((RDFFormat)format, (OutputStream)response.getOutputStream()), new Resource[0]);
                }
                if (rc.hasStatement((Resource)graphName, RDF.TYPE, (Value)REPO.NAMED_GRAPH, true, new Resource[0])) {
                    rc.export((RDFHandler)Rio.createWriter((RDFFormat)format, (OutputStream)response.getOutputStream()), new Resource[]{graphName});
                }
                throw new NotFoundException("This URI is not a named graph: " + graphName);
            }
            catch (OpenRDFException e) {
                log.error((Object)"Failed exporting graph content: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            response.sendError(403, "User is not permitted to read this graph");
        }
    }
}

