/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.REPO;
import org.eaglei.repository.SPARQL;
import org.eaglei.repository.Views;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;

public class ListGraphs
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter("format");
        String type = request.getParameter("type");
        DatasetImpl uds = new DatasetImpl();
        Views.addGraphs((HttpServletRequest)request, (DatasetImpl)uds, (Views.View)Views.View.USER);
        StringBuilder query = new StringBuilder("SELECT DISTINCT * WHERE { ?namedGraphURI a <" + REPO.NAMED_GRAPH + "> . \n" + " OPTIONAL { ?namedGraphURI <" + RDFS.LABEL + "> ?namedGraphLabel } \n" + " OPTIONAL { ?namedGraphURI <" + REPO.NG_TYPE + "> ?typeURI . " + " ?typeURI <" + RDFS.LABEL + "> ?typeLabel } \n" + " FILTER( ");
        if (type != null) {
            REPO.NGType ngt = REPO.NGType.parse((String)type);
            if (ngt == null) {
                throw new BadRequestException("Unrecognized graph type: " + type);
            }
            query.append("?typeURI = <" + ngt.uri + "> && ");
        }
        boolean first = true;
        query.append("( ");
        for (URI dg : uds.getDefaultGraphs()) {
            if (first) {
                first = false;
            } else {
                query.append(" || ");
            }
            query.append("?namedGraphURI = <").append(dg.toString()).append(">");
        }
        query.append(") ) }");
        SPARQL.tupleQueryRequest((HttpServletRequest)request, (HttpServletResponse)response, (String)query.toString(), (String)format, (Dataset)SPARQL.InternalGraphs);
    }
}

