/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.BadRequestException;
import org.eaglei.repository.DataRepositoryLifecycle;
import org.eaglei.repository.ID;
import org.eaglei.repository.SPARQL;
import org.eaglei.repository.servlet.RepositoryServlet;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.impl.MapBindingSet;

public class New
extends RepositoryServlet {
    private static Logger log = LogManager.getLogger(New.class);
    private static String[] columnNames = new String[]{"new"};

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int count = 1;
        String rawcount = null;
        String format = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(100000, (File)this.getServletConfig().getServletContext().getAttribute("javax.servlet.context.tempdir")));
                for (DiskFileItem item : upload.parseRequest(request)) {
                    String ifn = item.getFieldName();
                    if (ifn.equals("count")) {
                        rawcount = item.getString();
                        continue;
                    }
                    if (ifn.equals("format")) {
                        format = item.getString();
                        continue;
                    }
                    log.warn((Object)("Unrecoginized request argument: " + ifn));
                }
            }
            catch (FileUploadException e) {
                log.error((Object)e);
                response.sendError(400, "failed parsing multipart request");
                return;
            }
        } else {
            rawcount = request.getParameter("count");
            format = request.getParameter("format");
        }
        if (rawcount != null) {
            try {
                count = Integer.parseInt(rawcount);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("The 'count' argument was not an integer: " + count);
            }
        }
        if (count <= 0) {
            throw new BadRequestException("The 'count' argument was not an integer greater than 0: " + count);
        }
        log.debug((Object)("Got /new GET request, count=" + count));
        String[] ids = ID.newIDs((int)count);
        ArrayList<MapBindingSet> results = new ArrayList<MapBindingSet>(ids.length);
        for (String id : ids) {
            MapBindingSet bs = new MapBindingSet(1);
            bs.addBinding(columnNames[0], (Value)new URIImpl(DataRepositoryLifecycle.getDefaultNamespace() + id));
            results.add(bs);
        }
        SPARQL.sendTupleQueryResults((HttpServletRequest)request, (HttpServletResponse)response, (String)format, results);
    }
}

