<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   - Admin - present a list of named graphs, the name-or-URI of each
   -  is a link to the page to edit its ACL.
  --%>

<%@ page import="java.io.ByteArrayOutputStream" %>
<%@ page import="java.io.Writer" %>
<%@ page import="java.io.IOException" %>
<%@ page import="org.apache.log4j.Logger" %>
<%@ page import="org.apache.log4j.LogManager" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="org.openrdf.query.Dataset" %>
<%@ page import="org.openrdf.query.impl.DatasetImpl" %>
<%@ page import="org.openrdf.model.Literal" %>
<%@ page import="org.openrdf.model.Value" %>
<%@ page import="org.openrdf.model.URI" %>
<%@ page import="org.openrdf.model.vocabulary.RDFS" %>
<%@ page import="org.openrdf.query.BindingSet" %>
<%@ page import="org.openrdf.query.TupleQuery" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandler" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandlerBase" %>
<%@ page import="org.openrdf.query.TupleQueryResultHandlerException" %>
<%@ page import="org.openrdf.query.QueryLanguage" %>
<%@ page import="org.openrdf.query.MalformedQueryException" %>
<%@ page import="org.openrdf.OpenRDFException" %>
<%@ page import="org.openrdf.repository.RepositoryConnection" %>
<%@ page import="org.eaglei.repository.Access" %>
<%@ page import="org.eaglei.repository.Constants" %>
<%@ page import="org.eaglei.repository.Views" %>
<%@ page import="org.eaglei.repository.REPO" %>
<%@ page import="org.eaglei.repository.SPARQL" %>
<%@ page import="org.eaglei.repository.BadRequestException" %>

<%! private static Logger log = LogManager.getLogger("org.eaglei.repository.admin.namedGraphs.jsp"); %>
<%!
    /** handler to print a line of the table for each result */
    // XXX fix me later:
    // in retrospect, it would have been simpler to have the handler assemble a
    // List of record instances, rather than generate HTML the hard way..
    private static class graphHandler extends TupleQueryResultHandlerBase
    {
        private Writer w = null;

        public graphHandler(Writer u)
        {
            super();
            graphHandler.this.w = u;
        }
        // columns: namedGraphURI, namedGraphLabel, typeURI, typeLabel, anon
        public void handleSolution(BindingSet bs)
            throws TupleQueryResultHandlerException
        {
            Value ngURI = bs.getValue("namedGraphURI");
            Value ngLabel = bs.getValue("namedGraphLabel");
            Value typeURI = bs.getValue("typeURI");
            Value typeLabel = bs.getValue("typeLabel");
            Value anon = bs.getValue("anon");
            if (ngURI == null || !(ngURI instanceof URI))
                throw new TupleQueryResultHandlerException(
                    "Should not get null or non-URI result in graphHandler: "+ngURI);
            else {
                String ngl = (ngLabel != null && ngLabel instanceof Literal) ?
                           ((Literal)ngLabel).getLabel() : ngURI.toString();
                String tl = "n/a";
                String al = anon == null ? "No" : "Yes";
                if (typeLabel != null && typeLabel instanceof Literal)
                    tl = ((Literal)typeLabel).getLabel();
                else if (typeURI != null)
                    tl = ((URI)typeURI).getLocalName();
                try {
                    w.append("\n<tr><td><a href=\"/repository/admin/editGraph.jsp?uri=").
                      append(ngURI.toString()).append("\">");
                    w.append(StringEscapeUtils.escapeHtml(ngl)).
                      append("</a></td>\n<td>");
                    w.append("<form style=\"margin: 0pt;\" action=\"/repository/admin/editGrants.jsp\">").
                      append("<input type=\"hidden\" name=\"type\" value=\"Named Graph\" />").
                      append("<input type=\"hidden\" name=\"label\" value=\"").
                      append(StringEscapeUtils.escapeHtml(ngl)).append("\"/>").
                      append("<input type=\"hidden\" name=\"uri\" value=\"").
                      append(ngURI.toString()).append("\"/>").
                      append("<button type=\"submit\">Edit ACL</button></form>").
                      append("</td>\n<td>");
                    w.append(tl).append("</td>\n<td align=\"center\">");
                    w.append(al).append("</td>\n</tr>");
                } catch (IOException e) {
                    throw new TupleQueryResultHandlerException(e);
                }
            }
        }
    }
%>

  <head>
    <title>Eagle-I Data Repository Admin - Named Graphs</title>
  </head>
  <body>
    <%@ include file="/repository/admin/banner.jsp" %>
    <h2>Named Graphs Administration</h2>
    <table border="1">
    <tr><th colspan="2">Graph Name or URI</th><th>Content Type</th><th>Public?</th></tr>
    <%
        String query =
          "SELECT DISTINCT * WHERE { ?namedGraphURI a <"+REPO.NAMED_GRAPH+"> . \n"+
          " OPTIONAL { ?namedGraphURI <"+RDFS.LABEL+"> ?namedGraphLabel } \n"+
          " OPTIONAL { ?namedGraphURI <"+REPO.NG_TYPE+"> ?typeURI . "+
                       " ?typeURI <"+RDFS.LABEL+"> ?typeLabel } \n"+
          " OPTIONAL { ?namedGraphURI <"+REPO.HAS_READ_ACCESS+"> ?anon \n"+
          "            FILTER( ?anon = <"+REPO.ROLE_ANONYMOUS+"> )}}\n"+
          " ORDER BY ?typeURI";
        log.debug("Query to collect named graphs = "+query);
        RepositoryConnection rc = (RepositoryConnection)request.getAttribute(Constants.ATTR_CONNECTION);
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
            q.setIncludeInferred(true);
            q.setDataset(SPARQL.InternalGraphs);
            q.evaluate(new graphHandler(out));
        } catch (MalformedQueryException e) {
            log.info("Rejecting malformed query: "+e);
            response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "Malformed query was generated internally: "+e.toString());
        } catch (OpenRDFException e) {
            log.error(e);
            throw new ServletException(e);
        }
%>
</table>
    <i>Click on name to edit named graph properties.</i>

    <br/>
    <br/>
    <a href="/repository/admin/index.jsp">Return to Admin top level</a>
  </body>
</html>
             
