/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.Serializable;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class CountResult
implements Serializable,
Comparable<CountResult> {
    private EIEntity entity;
    private Integer count;
    private String definition;
    private boolean hasSubEntity;

    protected CountResult() {
    }

    public CountResult(EIEntity entity) {
        this(entity, 0);
    }

    public CountResult(EIEntity entity, int count) {
        this.entity = entity;
        this.count = count;
    }

    public CountResult(CountResult copy) {
        this(copy.getEntity(), copy.getCount());
    }

    public EIEntity getEntity() {
        return this.entity;
    }

    public Integer getCount() {
        return this.count;
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int n) {
        this.count = this.count + n;
    }

    public void decrement() {
        this.decrement(1);
    }

    public void decrement(int n) {
        this.count = this.count - n;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public boolean hasSubEntity() {
        return this.hasSubEntity;
    }

    public void setHasSubEntity(boolean hasSubEntity) {
        this.hasSubEntity = hasSubEntity;
    }

    public boolean equals(Object o) {
        if (o instanceof EIURI) {
            return ((EIURI)o).equals((Object)this.getEntity().getURI());
        }
        if (o instanceof EIEntity) {
            return ((EIEntity)o).equals((Object)this.getEntity());
        }
        if (o instanceof CountResult) {
            return ((CountResult)o).equals(this.getEntity());
        }
        return false;
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    @Override
    public int compareTo(CountResult o) {
        int result = o.count.compareTo(this.count);
        if (result == 0) {
            result = this.entity.compareTo(o.entity);
        }
        return result;
    }

    public String toString() {
        return this.entity.toString() + "  (" + this.count + ")";
    }
}

