package org.eaglei.search.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Properties;

/**
 * Configuration for the search application. 
 */
// TODO switch to XML-based config (use something like JAXB); leaving JAXB out for now has some advantages
public class SearchConfiguration implements Serializable {

    public static final String PROVIDER_FACTORY_CLASS = "search.provider.factory.class";
    
    private Properties props = new Properties();
    
    public SearchConfiguration(final File propFile) throws IOException {
        this(new FileReader(propFile));
    }
    
    public SearchConfiguration(final Reader propFileContents) throws IOException {
    	this.props.load(propFileContents);
    }
    
    public String getSearchProviderFactoryClass() {
        return props.getProperty(PROVIDER_FACTORY_CLASS);
    }
    
    public Properties getProperties() {
        return this.props;
    }
    
    public String getFromConfigOrSystem(final String prop) {
        String value = this.props.getProperty(prop);
        if (value == null) {
            value = System.getProperty(prop);
        }
        return value;
    }
}
