package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;

import org.eaglei.model.EIEntity;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;

/**
 * Interface for classes that can execute search requests on multiple destinations.
 * 
 * @author rfrost
 * 
 * @see SearchRequest
 * @see SearchResultSet
 * @see SearchProvider
 */
public interface MultiNodeSearchProvider {
    
    /**
     * Initializes the provider. Must be called before query or getInstitutions.
     * @throws IOException Thrown if an error is encountered initializing the provider.
     */
    public void init() throws IOException;
    
    /**
     * Retrieves EIEntity instances that represent the institutions associated with this provider.
     * 
     * @return Collection of EIEntities that represent the underlying institutions. Will be empty before
     * init has been called.
     */
    public Collection<EIEntity> getInstitutions();
    
    /**
     * Executes the specified search request (potentially against multiple destinations) and returns a 
     * collection of SearchResultSets as a synchronous operation. 
     * One SearchResultSet will be returned from each destination in the network.
     * 
     * @param request The search request.
     * @return Collection of SearchResultSets. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search.
     */
    public Collection<SearchResultSet> query(SearchRequest request) throws IOException;
    
}
