package org.eaglei.search.provider;

import java.io.IOException;

import org.eaglei.search.config.SearchConfiguration;

/**
 * Interface for MultiNodeSearchProvider factory classes.
 */
public interface MultiNodeSearchProviderFactory {
    
    /**
     * Creates a new MultiNodeSearchProvider.
     *
     * @param config Search configuration.
     * 
     * @return MultiNodeSearchProvider.
     * 
     * @throws IOException Thrown if an error is encountered creating the provider. 
     */
    public MultiNodeSearchProvider createMultiNodeSearchProvider(SearchConfiguration config) throws IOException;
    
}
