package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;

import org.eaglei.model.EIEntity;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;

/**
 * Interface for classes that can execute search requests on a single node.
 * 
 * @author rfrost
 * 
 * @see SearchRequest
 * @see SearchResultSet
 */
public interface SearchProvider {
    
    /**
     * Initializes the provider. Must be called before query or getInstitution
     * @throws IOException Thrown if an error is encountered initializing the provider.
     */
    public void init() throws IOException;
    
    /**
     * Retrieves EIEntity instances represening the institutions associated with this provider.
     * 
     * @return Collection of EIEntities that represent the underlying institutions. Will be empty before
     * init has been called.
     */
    public Collection<EIEntity> getInstitutions();
    
    /**
     * Executes the specified search request and returns a SearchResultSet as a
     * synchronous operation.
     * 
     * @param request The search request.
     * @return Set of search results. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search. 
     */
    public SearchResultSet query(SearchRequest request) throws IOException;

}
