package org.eaglei.search.provider;

import java.io.IOException;

import org.eaglei.search.config.SearchConfiguration;

/**
 * Interface for SearchProvider factory classes.
 */
public interface SearchProviderFactory {
    
    /**
     * Creates a new SearchProvider.
     *
     * @param config Search configuration.
     * 
     * @return SearchProvider.
     * 
     * @throws IOException Thrown if an error is encountered creating the provider. 
     */
    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException;
    
}
