/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.common;

import org.eaglei.search.common.GsonHolder;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;

public interface Serializer<T> {
    public static final Serializer<SearchRequest> SearchRequestSerializer = new Serializer<SearchRequest>(){

        @Override
        public String serialize(SearchRequest request) throws SerializationException {
            assert (request != null);
            return request.toURLParams();
        }

        @Override
        public SearchRequest deserialize(String serialized) throws SerializationException {
            assert (serialized != null);
            SearchRequest request = SearchRequest.parse(serialized);
            if (request == null) {
                throw new SerializationException("Error unmarshalling SearchRequest; got null result for: '" + serialized + "'");
            }
            return request;
        }
    };
    public static final Serializer<SearchResultSet> SearchResultSetSerializer = new Serializer<SearchResultSet>(){

        @Override
        public String serialize(SearchResultSet resultSet) throws SerializationException {
            return GsonHolder.Gson.toJson((Object)resultSet, SearchResultSet.class);
        }

        @Override
        public SearchResultSet deserialize(String serialized) throws SerializationException {
            return (SearchResultSet)GsonHolder.Gson.fromJson(serialized, SearchResultSet.class);
        }
    };
    public static final Serializer<String> NullSerializer = new Serializer<String>(){

        @Override
        public String deserialize(String serialized) throws SerializationException {
            return serialized;
        }

        @Override
        public String serialize(String object) throws SerializationException {
            return object;
        }
    };

    public String serialize(T var1) throws SerializationException;

    public T deserialize(String var1) throws SerializationException;
}

