/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public class SearchResultRankMerger
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(SearchResultRankMerger.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private MultiNodeSearchProvider nestedProvider;
    private boolean trimToRange = true;

    public SearchResultRankMerger(MultiNodeSearchProvider nestedProvider) {
        this.nestedProvider = nestedProvider;
    }

    public void setTrimToRange(boolean trimToRange) {
        this.trimToRange = trimToRange;
    }

    public boolean getTrimToRange() {
        return this.trimToRange;
    }

    @Override
    public void init() throws IOException {
        this.nestedProvider.init();
    }

    @Override
    public Collection<EIEntity> getInstitutions() {
        return this.nestedProvider.getInstitutions();
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        int startIndex = request.getStartIndex();
        request.setStartIndex(0);
        request.setMaxResults(startIndex + request.getMaxResults());
        Collection<SearchResultSet> results = this.nestedProvider.query(request);
        request.setStartIndex(startIndex);
        return this.merge(results, request);
    }

    private SearchResultSet merge(Collection<SearchResultSet> results, SearchRequest request) {
        SearchResultSet merged = null;
        if (results.size() == 1) {
            if (DEBUG) {
                logger.debug((Object)"Collection only included one SearchResultSet, returning that");
            }
            merged = results.iterator().next();
        } else {
            if (results.size() == 0) {
                if (DEBUG) {
                    logger.debug((Object)"Collection was empty returning empty SearchResultSet");
                }
                SearchResultSet empty = new SearchResultSet(request);
                empty.setTotalCount(0);
                return empty;
            }
            merged = new SearchResultSet(request);
            List<SearchResult> mergedResults = merged.getResults();
            TreeSet<SearchResult> sortedResults = new TreeSet<SearchResult>();
            if (DEBUG) {
                logger.debug((Object)("Merging " + results.size() + " SearchResultSets"));
            }
            boolean start = false;
            for (SearchResultSet resultSet : results) {
                if (DEBUG) {
                    logger.debug((Object)("Merging result set with " + resultSet.getResults().size() + " results and start " + resultSet.getStartIndex()));
                }
                merged.setTotalCount(merged.getTotalCount() + resultSet.getTotalCount());
                for (SearchResult result : resultSet.getResults()) {
                    if (!sortedResults.contains(result)) {
                        sortedResults.add(result);
                        continue;
                    }
                    merged.setTotalCount(merged.getTotalCount() - 1);
                }
            }
            for (SearchResult result : sortedResults) {
                merged.getResults().add(result);
            }
            if (DEBUG) {
                logger.debug((Object)("Size of merged result set: " + merged.getResults().size()));
            }
        }
        if (this.getTrimToRange()) {
            return this.trimToRange(merged, request);
        }
        return merged;
    }

    private SearchResultSet trimToRange(SearchResultSet results, SearchRequest request) {
        if (DEBUG) {
            logger.debug((Object)("Trimming to range " + request.getStartIndex() + " to " + (request.getStartIndex() + request.getMaxResults())));
        }
        SearchResultSet trimmed = new SearchResultSet(request);
        trimmed.setStartIndex(request.getStartIndex());
        trimmed.setTotalCount(results.getTotalCount());
        List<SearchResult> list = results.getResults();
        int numToRemoveOnFront = request.getStartIndex() - results.getStartIndex();
        if (numToRemoveOnFront < 0) {
            numToRemoveOnFront = 0;
        }
        for (int i = numToRemoveOnFront; i < numToRemoveOnFront + request.getMaxResults() && i < list.size(); ++i) {
            trimmed.getResults().add(list.get(i));
        }
        if (DEBUG) {
            logger.debug((Object)("Trimmed result start: " + trimmed.getStartIndex() + ", trimmed size " + trimmed.getResults().size()));
        }
        return trimmed;
    }
}

