package org.eaglei.search.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.config.SearchProperties;

import org.eaglei.model.jena.JenaEIOntModel;

/**
 * SearchProvider utility logic.
 */
public class SearchProviderUtil {

    /**
     * Gets the institution
     * 
     * @return institution EIEntity
     */
    /*
    public static EIEntity getInstitution(EIOntModel eagleiOntModel) {
        String node = System.getProperty(SearchProperties.SEARCH_NODE);
        assert(node != null) : "System property search.node must be set";
        assert(!SearchProperties.CENTRAL.equals(node)) : "Should not call getInstitution() on the central node.";
        return getInstitutionEntity(node, eagleiOntModel);
    }
    */
    
    /**
     * Retrieves the EIEntity for the specified URI
     * @param uri Institution URI.
     * @return EIEntity based on the University instances loaded via the eagle-i OWL files.
     */
    /*
    public static EIEntity getInstitutionEntity(final String uri, EIOntModel eagleiOntModel) {
        for (EIEntity entity : eagleiOntModel.getInstitutions()) {
            if (entity.getURI().toString().equals(uri)) {
                return entity;
            }
        }
        return null;
    }
    */
    
    /**
     * Convenience method for getting a list of the institutional data accessible
     * from this server. 
     * 
     * @return List of institution EIEntities
     */
    /*
    public static List<EIEntity> getInstitutions(EIOntModel eagleiOntModel) {
        final String node = System.getProperty(SearchProperties.SEARCH_NODE);
        if (SearchProperties.CENTRAL.equals(node)) {
            return eagleiOntModel.getInstitutions();
        } else {
            return Collections.singletonList(getInstitution(eagleiOntModel));  
        }
    }
    */
    
    /**
     * Retrieves the institution EIEntities from the specified SearchProvider via a SearchRequest 
     * 
     * @param provider Provider from which the institutions are retrieved.
     * 
     * @return Collection of institution EIEntities.
     * 
     * @throws IOException
     */
    /*
    public static Collection<EIEntity> getInstitutions(final SearchProvider provider) throws IOException {
        assert provider != null;
        
        // create an institution SearchRequest
        final SearchRequest institutionRequest = new SearchRequest(EIURI.create(EagleIOntConstants.UNIVERSITY_CLASS_URI));
        
        // execute the institution query against the provider
        final SearchResultSet results = provider.query(institutionRequest);
        
        // gather the unique institution entities from the results
        final Set<EIEntity> institutions = new HashSet<EIEntity>();
        for (SearchResult result: results.getResults()) {
            institutions.add(result.getEntity());
        }
        return institutions;
    }
    */
    
    /**
     * Retrieves the institution EIEntities from the specified MultiNodeSearchProvider via a SearchRequest
     *  
     * @param provider Provider from which the institutions are retrieved.
     * 
     * @return Collection of institution EIEntities.
     * 
     * @throws IOException
     */
    /*
    public static Collection<EIEntity> getInstitutions(final MultiNodeSearchProvider provider) throws IOException {
        assert provider != null;
        
        // create an institution SearchRequest
        final SearchRequest institutionRequest = new SearchRequest(EIURI.create(EagleIOntConstants.UNIVERSITY_CLASS_URI));
        
        // execute the institution query against the provider        
        final Collection<SearchResultSet> results= provider.query(institutionRequest);
        
        // gather the unique institution entities from the results
        final Set<EIEntity> institutions = new HashSet<EIEntity>();
        for (SearchResultSet resultSet: results) {
            for (SearchResult result: resultSet.getResults()) {
                institutions.add(result.getEntity());
            }
        }
        return institutions;
    }
    */
    
    /*
     * Gets the type binding from the SearchRequest. The term type is returned first if set, then
     * the binding type.
     */
    // TODO potentially move this logic into SearchRequest
    public static EIURI getType(final SearchRequest request) {
        EIURI type = null;
        final SearchRequest.TypeBinding binding = request.getBinding();
        if (binding != null) {
            type = binding.getType();
        } 
        return type;
    }

}
