/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.datagen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;

public final class DataGenParams {
    private static final int DEFAULT_MIN_CORES = 1;
    private static final int DEFAULT_MAX_CORES = 3;
    private static final int DEFAULT_MIN_RESEARCH = 1;
    private static final int DEFAULT_MAX_RESEARCH = 3;
    private static final int DEFAULT_MIN_RESOURCES = 1;
    private static final int DEFAULT_MAX_RESOURCES = 5;
    public static final int MAX_RESOURCES = 25;
    private Map<String, String> institutionURIToName = new HashMap<String, String>();
    private int coreMin = 1;
    private int coreMax = 3;
    private int researchMin = 1;
    private int researchMax = 3;
    private int resourcePerClassMin = 1;
    private int resourcePerClassMax = 5;
    private boolean materializeHierarchy = false;

    public static DataGenParams createForAllInstitutions(List<EIEntity> institutions) {
        DataGenParams params = new DataGenParams();
        for (EIEntity institution : institutions) {
            params.addInstitution(institution.getURI().toString(), institution.getLabel());
        }
        return params;
    }

    public static DataGenParams createForOneInstitution(EIEntity institution) {
        return DataGenParams.createForOneInstitution(institution.getURI().toString(), institution.getLabel());
    }

    public static DataGenParams createForOneInstitution(String uri, String label) {
        DataGenParams params = new DataGenParams();
        params.addInstitution(uri, label);
        return params;
    }

    private DataGenParams() {
    }

    public void addInstitution(String institutionURI, String institutionName) {
        this.institutionURIToName.put(institutionURI, institutionName);
    }

    public void clearInstitutions() {
        this.institutionURIToName.clear();
    }

    public boolean getMaterializeHierarchy() {
        return this.materializeHierarchy;
    }

    public void setMaterializeHierarchy(boolean materializeHierarchy) {
        this.materializeHierarchy = materializeHierarchy;
    }

    public Set<String> getInstitutionURIs() {
        return this.institutionURIToName.keySet();
    }

    public String getInstitutionName(String uri) {
        return this.institutionURIToName.get(uri);
    }

    public void setCoreFacilityRange(int min, int max) {
        DataGenParams.checkRange(min, max);
        this.coreMin = min;
        this.coreMax = max;
    }

    public int getNumCoreFacilities() {
        return DataGenParams.getRandom(this.coreMin, this.coreMax);
    }

    public void setResearchFacilityRange(int min, int max) {
        DataGenParams.checkRange(min, max);
        this.researchMin = min;
        this.researchMax = max;
    }

    public int getNumResearchFacilities() {
        return DataGenParams.getRandom(this.researchMin, this.researchMax);
    }

    public void setResourceRange(int min, int max) {
        DataGenParams.checkRange(min, max);
        this.resourcePerClassMin = min;
        this.resourcePerClassMax = max;
    }

    public int getNumResourcesPerClass() {
        return DataGenParams.getRandom(this.resourcePerClassMin, this.resourcePerClassMax);
    }

    private static void checkRange(int lowerBound, int upperBound) {
        assert (lowerBound >= 0);
        assert (lowerBound <= upperBound);
    }

    public static int getRandom(int lowerBound, int upperBound) {
        int delta = (int)Math.floor(Math.random() * (double)(upperBound - lowerBound));
        return lowerBound + delta;
    }
}

