package org.eaglei.search.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchProvider;

/**
 * Simple implementation of MultiNodeSearchProvider that aggregates a set of
 * SearchProviders.
 */
public class AggregatingSearchProvider implements MultiNodeSearchProvider {

    final private List<SearchProvider> providers = new ArrayList<SearchProvider>();
    final private List<MultiNodeSearchProvider> multiNodeProviders = new ArrayList<MultiNodeSearchProvider>();    
    
    public AggregatingSearchProvider() {
    }
    
    public void addSearchProvider(SearchProvider provider) {
        providers.add(provider);
    }
    
    public void addMultiNodeSearchProvider(MultiNodeSearchProvider provider) {
        multiNodeProviders.add(provider);
    }
        
    @Override
    public Collection<SearchResultSet> query(SearchRequest request) throws IOException {
        final Set<SearchResultSet> results = new LinkedHashSet<SearchResultSet>();
        for (SearchProvider provider: providers) {
            results.add(provider.query(request));
        }
        for (MultiNodeSearchProvider provider: multiNodeProviders) {
            for (SearchResultSet resultSet: provider.query(request)) {
                results.add(resultSet);
            }
        }
        return results;
    }
    
    @Override    
    public Collection<SearchCounts> count(SearchCountRequest request) throws IOException {
        final Set<SearchCounts> results = new LinkedHashSet<SearchCounts>();
        for (SearchProvider provider: providers) {
            results.add(provider.count(request));
        }
        for (MultiNodeSearchProvider provider: multiNodeProviders) {
            for (SearchCounts counts: provider.count(request)) {
                results.add(counts);
            }
        }
        return results;
    }

    @Override
    public void init() throws IOException {
        for (SearchProvider provider: providers) {
            provider.init();
        }
        for (MultiNodeSearchProvider provider: multiNodeProviders) {
            provider.init();
        }        
    }

}
