package org.eaglei.search.config;

/**
 * Defines common search configuration properties.
 */
public class SearchProperties {
    
    /**
     * Value of "search.node" System property for central search
     */
    public static final String CENTRAL = "central";
    
    /**
     * Name of System property that determines whether a test configuration is used.
     */
    public static final String SEARCH_TEST = "org.eaglei.search.test";

    /**
     * Name of System property that determines whether a central index is created.
     */
    public static final String CENTRAL_INDEX = "org.eaglei.search.central.index";
    
    /** 
     * System property that holds a boolean value which controls
     * whether the index is updated by an indexer thread or just updated once during the init() method 
     */
    // Note: this is defined here because we need to disable at the global level (it is enabled by default)
    public static final String USE_INDEXER_THREAD = "org.eaglei.search.provider.lucene.composite.indexer.thread";
    // Controls whether RepositoryHarvester performs a single harvest when the index thread is disabled. 
    // Some unit tests want this, and some don't.
    public static final String PERFORM_HARVEST = "org.eaglei.search.provider.lucene.composite.indexer.harvest";    

}
