/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.eaglei.search.logging.AsynchronousLoggerCount;
import org.eaglei.search.logging.AsynchronousLoggerInstance;
import org.eaglei.search.logging.AsynchronousLoggerSearch;
import org.eaglei.search.logging.LogInfo;
import org.eaglei.search.logging.LogInfoCount;
import org.eaglei.search.logging.LogInfoInstance;
import org.eaglei.search.logging.LogInfoSearch;
import org.eaglei.search.provider.SearchRequest;
import org.junit.After;
import org.junit.Before;

public class AsynchronousLoggerTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(AsynchronousLoggerTest.class);
    private static boolean gotConnection = false;
    private static final String WARNING = "AsynchronousLogger tests were not run. A database connection is required.";
    private static final String TEST_TABLE = "LOGGING_TEST";
    private static final String JDBC = "jdbc:mysql://";
    private static final String LOCALHOST = "localhost:3306";
    private static final String DB_NAME = "searchlogdb";
    private static final String DB_USER = "searchlog";
    private static final String DB_PASSWORD = "s34rchl0g";
    private static final String SESSIONID = "sessionID";
    private static final String USERID = "userID";
    private static final String START = "111";
    private static final String END = "333";
    private static final String DURATION = "222";
    private static final String COUNT = "1212";
    private static final String BUILDID = "buildID";
    private static final String ONTOLOGYID = "ontologyID";
    private static final String INSTANCE_ID = "instanceid";
    private static final String INSTANCE_CLASS = "instanceclass";
    private static final String INSTANCE_LABEL = "instancelabel";
    private static final String INSTANCE_TYPE = "instancetype";
    private static final String UNK = "Unknown";

    @Before
    public void setUp() throws Exception {
        this.killTable();
    }

    @After
    public void tearDown() throws Exception {
        this.killTable();
    }

    public void testAsyncLoggerSearch() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        try {
            AsynchronousLoggerSearch asyncLogger = new AsynchronousLoggerSearch(TEST_TABLE, BUILDID, ONTOLOGYID);
            Connection conn = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNotNull((Object)conn);
            PreparedStatement showTables = conn.prepareStatement("SHOW TABLES;");
            showTables.execute();
            ResultSet tables = showTables.getResultSet();
            AsynchronousLoggerTest.assertNotNull((Object)tables);
            AsynchronousLoggerTest.assertTrue((boolean)tables.next());
            AsynchronousLoggerTest.assertTrue((boolean)this.foundTestTable(tables));
            LogInfoSearch entry = new LogInfoSearch(SESSIONID, USERID, Long.parseLong(START), Long.parseLong(END), new SearchRequest(), Long.parseLong(COUNT), BUILDID, ONTOLOGYID);
            asyncLogger.log((LogInfo)entry);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            PreparedStatement select = conn.prepareStatement("SELECT * FROM LOGGING_TEST;");
            select.execute();
            ResultSet row = select.getResultSet();
            AsynchronousLoggerTest.assertTrue((boolean)row.next());
            String sessionValue = row.getString(2);
            AsynchronousLoggerTest.assertTrue((boolean)sessionValue.equals(SESSIONID));
            String userValue = row.getString(3);
            AsynchronousLoggerTest.assertTrue((boolean)userValue.equals(USERID));
            String startValue = row.getString(5);
            AsynchronousLoggerTest.assertTrue((boolean)startValue.equals(START));
            String endValue = row.getString(6);
            AsynchronousLoggerTest.assertTrue((boolean)endValue.equals(END));
            String durationValue = row.getString(7);
            AsynchronousLoggerTest.assertTrue((boolean)durationValue.equals(DURATION));
            String countValue = row.getString(9);
            AsynchronousLoggerTest.assertTrue((boolean)countValue.equals(COUNT));
            String buildValue = row.getString(20);
            AsynchronousLoggerTest.assertTrue((boolean)buildValue.equals(BUILDID));
            String ontologyValue = row.getString(21);
            AsynchronousLoggerTest.assertTrue((boolean)ontologyValue.equals(ONTOLOGYID));
            AsynchronousLoggerTest.assertFalse((boolean)row.next());
            asyncLogger.finalize();
            Connection conn2 = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNull((Object)conn2);
            conn.close();
            Object var2_3 = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            AsynchronousLoggerTest.assertTrue((boolean)false);
            return;
        }
    }

    public void testBadInputCasesSearch() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        AsynchronousLoggerSearch asyncLogger = new AsynchronousLoggerSearch(TEST_TABLE, "", "");
        String buildID = asyncLogger.getBuildID();
        String ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerSearch(TEST_TABLE, "  ", "  ");
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerSearch(TEST_TABLE, null, null);
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerSearch("", BUILDID, ONTOLOGYID);
        Connection conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerSearch("  ", BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerSearch(null, BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
    }

    public void testAsyncLoggerCount() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        try {
            AsynchronousLoggerCount asyncLogger = new AsynchronousLoggerCount(TEST_TABLE, BUILDID, ONTOLOGYID);
            Connection conn = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNotNull((Object)conn);
            PreparedStatement showTables = conn.prepareStatement("SHOW TABLES;");
            showTables.execute();
            ResultSet tables = showTables.getResultSet();
            AsynchronousLoggerTest.assertNotNull((Object)tables);
            AsynchronousLoggerTest.assertTrue((boolean)tables.next());
            AsynchronousLoggerTest.assertTrue((boolean)this.foundTestTable(tables));
            LogInfoCount entry = new LogInfoCount(SESSIONID, USERID, Long.parseLong(START), Long.parseLong(END), new SearchRequest(), BUILDID, ONTOLOGYID);
            asyncLogger.log((LogInfo)entry);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            PreparedStatement select = conn.prepareStatement("SELECT * FROM LOGGING_TEST;");
            select.execute();
            ResultSet row = select.getResultSet();
            AsynchronousLoggerTest.assertTrue((boolean)row.next());
            String sessionValue = row.getString(2);
            AsynchronousLoggerTest.assertTrue((boolean)sessionValue.equals(SESSIONID));
            String userValue = row.getString(3);
            AsynchronousLoggerTest.assertTrue((boolean)userValue.equals(USERID));
            String startValue = row.getString(5);
            AsynchronousLoggerTest.assertTrue((boolean)startValue.equals(START));
            String endValue = row.getString(6);
            AsynchronousLoggerTest.assertTrue((boolean)endValue.equals(END));
            String durationValue = row.getString(7);
            AsynchronousLoggerTest.assertTrue((boolean)durationValue.equals(DURATION));
            String buildValue = row.getString(9);
            AsynchronousLoggerTest.assertTrue((boolean)buildValue.equals(BUILDID));
            String ontologyValue = row.getString(10);
            AsynchronousLoggerTest.assertTrue((boolean)ontologyValue.equals(ONTOLOGYID));
            AsynchronousLoggerTest.assertFalse((boolean)row.next());
            asyncLogger.finalize();
            Connection conn2 = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNull((Object)conn2);
            conn.close();
            Object var2_3 = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            AsynchronousLoggerTest.assertTrue((boolean)false);
            return;
        }
    }

    public void testBadInputCasesCount() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        AsynchronousLoggerCount asyncLogger = new AsynchronousLoggerCount(TEST_TABLE, "", "");
        String buildID = asyncLogger.getBuildID();
        String ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerCount(TEST_TABLE, "  ", "  ");
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerCount(TEST_TABLE, null, null);
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerCount("", BUILDID, ONTOLOGYID);
        Connection conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerCount("  ", BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerCount(null, BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
    }

    public void testAsyncLoggerInstance() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        try {
            AsynchronousLoggerInstance asyncLogger = new AsynchronousLoggerInstance(TEST_TABLE, BUILDID, ONTOLOGYID);
            Connection conn = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNotNull((Object)conn);
            PreparedStatement showTables = conn.prepareStatement("SHOW TABLES;");
            showTables.execute();
            ResultSet tables = showTables.getResultSet();
            AsynchronousLoggerTest.assertNotNull((Object)tables);
            AsynchronousLoggerTest.assertTrue((boolean)tables.next());
            AsynchronousLoggerTest.assertTrue((boolean)this.foundTestTable(tables));
            LogInfoInstance entry = new LogInfoInstance(SESSIONID, USERID, Long.parseLong(START), Long.parseLong(END), INSTANCE_ID, INSTANCE_CLASS, INSTANCE_LABEL, INSTANCE_TYPE, BUILDID, ONTOLOGYID);
            asyncLogger.log((LogInfo)entry);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            PreparedStatement select = conn.prepareStatement("SELECT * FROM LOGGING_TEST;");
            select.execute();
            ResultSet row = select.getResultSet();
            AsynchronousLoggerTest.assertTrue((boolean)row.next());
            String sessionValue = row.getString(2);
            AsynchronousLoggerTest.assertTrue((boolean)sessionValue.equals(SESSIONID));
            String userValue = row.getString(3);
            AsynchronousLoggerTest.assertTrue((boolean)userValue.equals(USERID));
            String startValue = row.getString(5);
            AsynchronousLoggerTest.assertTrue((boolean)startValue.equals(START));
            String endValue = row.getString(6);
            AsynchronousLoggerTest.assertTrue((boolean)endValue.equals(END));
            String durationValue = row.getString(7);
            AsynchronousLoggerTest.assertTrue((boolean)durationValue.equals(DURATION));
            String instanceID = row.getString(8);
            AsynchronousLoggerTest.assertTrue((boolean)instanceID.equals(INSTANCE_ID));
            String instanceClass = row.getString(9);
            AsynchronousLoggerTest.assertTrue((boolean)instanceClass.equals(INSTANCE_CLASS));
            String instanceLabel = row.getString(10);
            AsynchronousLoggerTest.assertTrue((boolean)instanceLabel.equals(INSTANCE_LABEL));
            String instanceType = row.getString(11);
            AsynchronousLoggerTest.assertTrue((boolean)instanceType.equals(INSTANCE_TYPE));
            String buildValue = row.getString(12);
            AsynchronousLoggerTest.assertTrue((boolean)buildValue.equals(BUILDID));
            String ontologyValue = row.getString(13);
            AsynchronousLoggerTest.assertTrue((boolean)ontologyValue.equals(ONTOLOGYID));
            AsynchronousLoggerTest.assertFalse((boolean)row.next());
            asyncLogger.finalize();
            Connection conn2 = asyncLogger.getConnection();
            AsynchronousLoggerTest.assertNull((Object)conn2);
            conn.close();
            Object var2_3 = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            AsynchronousLoggerTest.assertTrue((boolean)false);
            return;
        }
    }

    public void testBadInputCasesInstance() {
        if (!gotConnection) {
            logger.warn((Object)WARNING);
            return;
        }
        AsynchronousLoggerInstance asyncLogger = new AsynchronousLoggerInstance(TEST_TABLE, "", "");
        String buildID = asyncLogger.getBuildID();
        String ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerInstance(TEST_TABLE, "  ", "  ");
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerInstance(TEST_TABLE, null, null);
        buildID = asyncLogger.getBuildID();
        ontID = asyncLogger.getOntologyID();
        AsynchronousLoggerTest.assertTrue((boolean)buildID.equals(UNK));
        AsynchronousLoggerTest.assertTrue((boolean)ontID.equals(UNK));
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerInstance("", BUILDID, ONTOLOGYID);
        Connection conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerInstance("  ", BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
        asyncLogger = new AsynchronousLoggerInstance(null, BUILDID, ONTOLOGYID);
        conn = asyncLogger.getConnection();
        AsynchronousLoggerTest.assertNull((Object)conn);
        asyncLogger.finalize();
    }

    private boolean foundTestTable(ResultSet tables) throws SQLException {
        boolean foundIt = false;
        if (!tables.first()) {
            return false;
        }
        String tableName = tables.getString(1);
        foundIt = tableName.equals(TEST_TABLE);
        while (tables.next() && !foundIt) {
            tableName = tables.getString(1);
            foundIt = tableName.equals(TEST_TABLE);
        }
        return foundIt;
    }

    private void killTable() throws SQLException {
        String url = "jdbc:mysql://localhost:3306/searchlogdb";
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, DB_USER, DB_PASSWORD);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = gotConnection = conn != null;
        if (!gotConnection) {
            return;
        }
        String dropTableCmd = "DROP TABLE IF EXISTS LOGGING_TEST;";
        PreparedStatement dropStmt = conn.prepareStatement(dropTableCmd);
        dropStmt.execute();
    }
}

