/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import org.eaglei.search.logging.AsynchronousLogger;
import org.eaglei.search.logging.LogInfo;
import org.eaglei.search.logging.LogInfoCount;
import org.eaglei.search.provider.SearchRequest;

public class AsynchronousLoggerCount
extends AsynchronousLogger {
    public static final int ROW_UUID_COL = 1;
    public static final int SESSIONID_COL = 2;
    public static final int USERID_COL = 3;
    public static final int DATE_COL = 4;
    public static final int START_COL = 5;
    public static final int END_COL = 6;
    public static final int DURATION_COL = 7;
    public static final int REQUEST_COL = 8;
    public static final int BUILDID_COL = 9;
    public static final int ONTOLOGYID_COL = 10;

    public AsynchronousLoggerCount(String tname, String buildVersion, String ontVersion) {
        super(tname, buildVersion, ontVersion);
    }

    @Override
    protected void createTable() {
        if (this.tableName == null) {
            logger.error((Object)"Table name was null.");
            this.conn = null;
            return;
        }
        if (this.tableName.trim().length() == 0) {
            logger.error((Object)"Table name was empty.");
            this.conn = null;
            return;
        }
        String createTableCmd = "CREATE TABLE IF NOT EXISTS " + this.tableName.trim() + " (" + "op_id varchar(128) character set ascii NOT NULL," + "session_id varchar(128) character set ascii NOT NULL," + "user_id varchar(128) character set ascii NOT NULL," + "date varchar(64) character set ascii NOT NULL," + "start bigint(20) NOT NULL," + "end bigint(20) NOT NULL," + "duration bigint(20) NOT NULL," + "search_request varchar(256) character set ascii NOT NULL," + "build_id varchar(128) character set ascii NOT NULL," + "ontology_id varchar(128) character set ascii NOT NULL" + ") ENGINE=MyISAM DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement createStmt = this.conn.prepareStatement(createTableCmd);
            createStmt.execute();
        }
        catch (SQLException e) {
            logger.error((Object)("Asynchronous logger failed to create table " + this.tableName));
            e.printStackTrace();
            try {
                this.conn.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            this.conn = null;
            return;
        }
    }

    @Override
    protected void fillInInsertCmd(LogInfo entryArg) {
        if (!(entryArg instanceof LogInfoCount)) {
            logger.error((Object)"Incorrect LogInfo type");
            return;
        }
        LogInfoCount entry = (LogInfoCount)entryArg;
        try {
            UUID opid = UUID.randomUUID();
            long end = entry.getEnd();
            long duration = end - entry.getStart();
            String date = this.dateFormat.format(new Date(end));
            this.insertCmd.setString(1, opid.toString());
            this.insertCmd.setString(2, entry.getSessionID());
            this.insertCmd.setString(3, entry.getUserID());
            this.insertCmd.setString(4, date);
            this.insertCmd.setLong(5, entry.getStart());
            this.insertCmd.setLong(6, entry.getEnd());
            this.insertCmd.setLong(7, duration);
            this.insertCmd.setString(8, entry.getRequest().toString());
            this.insertCmd.setString(9, entry.getBuildID());
            this.insertCmd.setString(10, entry.getOntologyID());
        }
        catch (SQLException sqle) {
            logger.error((Object)("AsynchronousLogger failed to fill in insert command: " + this.insertCmd.toString()));
        }
    }

    @Override
    protected void setInsertCmd() {
        if (this.conn != null) {
            String INSERT_CMD = "INSERT INTO " + this.tableName + " ( " + "op_id, session_id, user_id, date, start, end, " + "duration, search_request, build_id, ontology_id ) VALUES ( " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?" + " );";
            try {
                this.insertCmd = this.conn.prepareStatement(INSERT_CMD);
            }
            catch (SQLException e) {
                logger.error((Object)"Asynchronous Logger failed to create insert command");
                e.printStackTrace();
                try {
                    this.conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                this.conn = null;
            }
        }
    }

    public void log(String sessionID, String userID, long start, long end, SearchRequest request) {
        super.log(new LogInfoCount(sessionID, userID, start, end, request, this.buildID, this.ontologyID));
    }
}

