/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import org.eaglei.model.EIURI;
import org.eaglei.search.logging.AsynchronousLogger;
import org.eaglei.search.logging.LogInfo;
import org.eaglei.search.logging.LogInfoSearch;
import org.eaglei.search.provider.SearchRequest;

public class AsynchronousLoggerSearch
extends AsynchronousLogger {
    public static final int ROW_UUID_COL = 1;
    public static final int SESSIONID_COL = 2;
    public static final int USERID_COL = 3;
    public static final int DATE_COL = 4;
    public static final int START_COL = 5;
    public static final int END_COL = 6;
    public static final int DURATION_COL = 7;
    public static final int REQUEST_COL = 8;
    public static final int COUNT_COL = 9;
    public static final int TERM_COL = 10;
    public static final int TERMQUERY_COL = 11;
    public static final int TERMURI_COL = 12;
    public static final int BINDING_COL = 13;
    public static final int TYPEURI_COL = 14;
    public static final int INSTITUTION_COL = 15;
    public static final int RESPROV_COL = 16;
    public static final int RESPROVINST_COL = 17;
    public static final int RESPROVTYPE_COL = 18;
    public static final int RESPROVURI_COL = 19;
    public static final int BUILDID_COL = 20;
    public static final int ONTOLOGYID_COL = 21;

    public AsynchronousLoggerSearch(String tname, String buildVersion, String ontVersion) {
        super(tname, buildVersion, ontVersion);
    }

    @Override
    protected void createTable() {
        if (this.tableName == null) {
            logger.error((Object)"Table name was null.");
            this.conn = null;
            return;
        }
        if (this.tableName.trim().length() == 0) {
            logger.error((Object)"Table name was empty.");
            this.conn = null;
            return;
        }
        String createTableCmd = "CREATE TABLE IF NOT EXISTS " + this.tableName.trim() + " (" + "op_id varchar(128) character set ascii NOT NULL," + "session_id varchar(128) character set ascii NOT NULL," + "user_id varchar(128) character set ascii NOT NULL," + "date varchar(64) character set ascii NOT NULL," + "start bigint(20) NOT NULL," + "end bigint(20) NOT NULL," + "duration bigint(20) NOT NULL," + "search_request varchar(256) character set ascii NOT NULL," + "num_results bigint(20) NOT NULL," + "request_term varchar(256) character set ascii NOT NULL," + "term_query varchar(256) character set ascii NOT NULL," + "term_uri varchar(256) character set ascii NOT NULL," + "request_type_binding varchar(256) character set ascii NOT NULL," + "type_binding_uri varchar(256) character set ascii NOT NULL," + "request_institution varchar(256) character set ascii NOT NULL," + "request_resource_provider varchar(256) character set ascii NOT NULL," + "res_prov_institution varchar(256) character set ascii NOT NULL," + "res_prov_type varchar(256) character set ascii NOT NULL," + "res_prov_uri varchar(256) character set ascii NOT NULL," + "build_id varchar(128) character set ascii NOT NULL," + "ontology_id varchar(128) character set ascii NOT NULL" + ") ENGINE=MyISAM DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement createStmt = this.conn.prepareStatement(createTableCmd);
            createStmt.execute();
        }
        catch (SQLException e) {
            logger.error((Object)("Asynchronous logger failed to create table " + this.tableName));
            e.printStackTrace();
            try {
                this.conn.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            this.conn = null;
            return;
        }
    }

    @Override
    protected void setInsertCmd() {
        if (this.conn != null) {
            String INSERT_CMD = "INSERT INTO " + this.tableName + " ( " + "op_id, session_id, user_id, date, start, end, " + "duration, search_request, num_results, " + "request_term, term_query, term_uri, request_type_binding, type_binding_uri," + "request_institution, request_resource_provider, res_prov_institution, res_prov_type, res_prov_uri," + "build_id, ontology_id ) VALUES ( " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?" + " );";
            try {
                this.insertCmd = this.conn.prepareStatement(INSERT_CMD);
            }
            catch (SQLException e) {
                logger.error((Object)"Asynchronous Logger failed to create insert command");
                e.printStackTrace();
                try {
                    this.conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                this.conn = null;
            }
        }
    }

    @Override
    protected void fillInInsertCmd(LogInfo entryArg) {
        if (!(entryArg instanceof LogInfoSearch)) {
            logger.error((Object)"Incorrect LogInfo type");
            return;
        }
        LogInfoSearch entry = (LogInfoSearch)entryArg;
        try {
            SearchRequest.ResourceProvider resourceProvider;
            EIURI institution;
            SearchRequest.TypeBinding typeBinding;
            UUID opid = UUID.randomUUID();
            long end = entry.getEnd();
            long duration = end - entry.getStart();
            String termStr = "null";
            String termQueryStr = "null";
            String termUriStr = "null";
            String bindStr = "null";
            String typeUriStr = "null";
            String institutionStr = "null";
            String resourceProviderStr = "null";
            String rpInstStr = "null";
            String rpTypeStr = "null";
            String rpUriStr = "null";
            SearchRequest request = entry.getRequest();
            SearchRequest.Term term = request.getTerm();
            if (term != null) {
                termStr = term.toString();
                if (term.getQuery() != null) {
                    termQueryStr = term.getQuery();
                }
                if (term.getURI() != null) {
                    termUriStr = term.getURI().toString();
                }
            }
            if ((typeBinding = request.getBinding()) != null) {
                bindStr = typeBinding.toString();
                if (typeBinding.getType() != null) {
                    typeUriStr = typeBinding.getType().toString();
                }
            }
            if ((institution = request.getInstitution()) != null) {
                institutionStr = institution.toString();
            }
            if ((resourceProvider = request.getLocation()) != null) {
                resourceProviderStr = resourceProvider.toString();
                if (resourceProvider.getInstitution() != null) {
                    rpInstStr = resourceProvider.getInstitution().toString();
                }
                if (resourceProvider.getType() != null) {
                    rpTypeStr = resourceProvider.getType().toString();
                }
                if (resourceProvider.getURI() != null) {
                    rpUriStr = resourceProvider.getURI().toString();
                }
            }
            String date = this.dateFormat.format(new Date(end));
            this.insertCmd.setString(1, opid.toString());
            this.insertCmd.setString(2, entry.getSessionID());
            this.insertCmd.setString(3, entry.getUserID());
            this.insertCmd.setString(4, date);
            this.insertCmd.setLong(5, entry.getStart());
            this.insertCmd.setLong(6, entry.getEnd());
            this.insertCmd.setLong(7, duration);
            this.insertCmd.setString(8, entry.getRequest().toString());
            this.insertCmd.setLong(9, entry.getCount());
            this.insertCmd.setString(10, termStr);
            this.insertCmd.setString(11, termQueryStr);
            this.insertCmd.setString(12, termUriStr);
            this.insertCmd.setString(13, bindStr);
            this.insertCmd.setString(14, typeUriStr);
            this.insertCmd.setString(15, institutionStr);
            this.insertCmd.setString(16, resourceProviderStr);
            this.insertCmd.setString(17, rpInstStr);
            this.insertCmd.setString(18, rpTypeStr);
            this.insertCmd.setString(19, rpUriStr);
            this.insertCmd.setString(20, entry.getBuildID());
            this.insertCmd.setString(21, entry.getOntologyID());
        }
        catch (SQLException sqle) {
            logger.error((Object)("AsynchronousLogger failed to fill in insert command: " + this.insertCmd.toString()));
        }
    }

    public void log(String sessionID, String userID, long start, long end, SearchRequest request, long count) {
        super.log(new LogInfoSearch(sessionID, userID, start, end, request, count, this.buildID, this.ontologyID));
    }
}

