/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.logging.LogInfo;

public abstract class AsynchronousLogger {
    protected static final Log logger = LogFactory.getLog(AsynchronousLogger.class);
    protected Connection conn = null;
    private final int RETRY_INTERVAL = 30000;
    private final int MAX_RETRIES = 10;
    private final BlockingQueue<LogInfo> logQueue = new LinkedBlockingQueue<LogInfo>();
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSS");
    protected String buildID = "";
    protected String ontologyID = "";
    protected String tableName = null;
    public static final String tableVersion = "_V1";
    private String loggerName = "";
    protected PreparedStatement insertCmd = null;
    private static final String JDBC = "jdbc:mysql://";
    private static final String LOCALHOST = "localhost:3306";
    private static final String DB_NAME = "searchlogdb";
    private static final String DB_USER = "searchlog";
    private static final String DB_PASSWORD = "s34rchl0g";
    private String jdbc = "jdbc:mysql://";
    private String localhost = "localhost:3306";
    private String db_name = "searchlogdb";
    private String db_user = "searchlog";
    private String db_password = "s34rchl0g";
    private static final String UNK = "Unknown";

    public AsynchronousLogger(String tname, String buildVersion, String ontVersion) {
        if (tname == null) {
            logger.error((Object)"Table name was null.");
            this.conn = null;
            return;
        }
        if (tname.trim().length() == 0) {
            logger.error((Object)"Table name was empty.");
            this.conn = null;
            return;
        }
        this.tableName = tname.trim() + tableVersion;
        this.buildID = buildVersion;
        this.ontologyID = ontVersion;
        this.init();
    }

    private void init() {
        this.checkBuildOntID();
        this.getDBproperties();
        this.connectDB(false);
        if (this.conn == null) {
            return;
        }
        this.createTable();
        if (this.conn == null) {
            return;
        }
        this.setInsertCmd();
        this.startLogging();
        logger.info((Object)("Asynchronous Logger started for table " + this.tableName));
    }

    private void checkBuildOntID() {
        if (this.ontologyID == null) {
            this.ontologyID = UNK;
        } else if (this.ontologyID.trim().length() == 0) {
            this.ontologyID = UNK;
        }
        if (this.buildID == null) {
            this.buildID = UNK;
        } else if (this.buildID.trim().length() == 0) {
            this.buildID = UNK;
        }
        logger.info((Object)("AsynchronousLogger using " + this.buildID + " as build identifier, and " + this.ontologyID + " as ontology identifer."));
    }

    private void getDBproperties() {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream("/usr/share/tomcat6/eaglei/.config/asynclogger.properties");
        }
        catch (FileNotFoundException e1) {
            logger.warn((Object)"AsynchronousLogger could not find asynclogger.properties. Using default values.");
            return;
        }
        if (stream == null) {
            logger.warn((Object)"AsynchronousLogger could not find asynclogger.properties. Using default values.");
            return;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException e) {
            logger.warn((Object)"AsynchronousLogger found but could not read asynclogger.properties. Using default values.");
            return;
        }
        this.jdbc = props.getProperty("JDBC", JDBC);
        this.localhost = props.getProperty("LOCALHOST", LOCALHOST);
        this.db_name = props.getProperty("DB_NAME", DB_NAME);
        this.db_user = props.getProperty("DB_USER", DB_USER);
        this.db_password = props.getProperty("DB_PASSWORD", DB_PASSWORD);
    }

    private void connectDB(boolean silent) {
        String url = this.jdbc + this.localhost + "/" + this.db_name;
        if (!silent) {
            String driverName = "org.gjt.mm.mysql.Driver";
            try {
                Class.forName(driverName);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("AsynchronousLogger could not find JDBC driver " + driverName));
                logger.info((Object)("Thread name: " + Thread.currentThread().getName()));
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                if (drivers.hasMoreElements()) {
                    logger.info((Object)"Enumerating known drivers:");
                    while (drivers.hasMoreElements()) {
                        Driver d = drivers.nextElement();
                        logger.info((Object)("    " + d.getClass().getName()));
                    }
                } else {
                    logger.info((Object)"There are no known drivers.");
                }
                ClassLoader cloader = this.getClass().getClassLoader();
                StringBuffer classpath = new StringBuffer();
                URL[] urls = ((URLClassLoader)cloader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    classpath.append(urls[i].getFile()).append("\r\n");
                }
                logger.info((Object)("Classpath: " + classpath.toString()));
                logger.info((Object)("Will attempt to connect with the following URL and credentials: " + url + "   User: " + this.db_user + "   Password: " + this.db_password));
            }
        }
        try {
            this.conn = DriverManager.getConnection(url, this.db_user, this.db_password);
        }
        catch (Exception e) {
            if (!silent) {
                logger.warn((Object)"AsynchronousLogger failed to get a database connection.");
            }
            return;
        }
    }

    protected abstract void createTable();

    protected abstract void setInsertCmd();

    protected abstract void fillInInsertCmd(LogInfo var1);

    private void startLogging() {
        this.loggerName = "AsyncLogger_" + this.tableName;
        Thread logThread = new Thread((Runnable)new LoggerDaemon(), this.loggerName);
        logThread.setPriority(1);
        logThread.setDaemon(true);
        logThread.start();
    }

    public void log(LogInfo entry) {
        if (this.conn == null) {
            return;
        }
        this.logQueue.add(entry);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public String getOntologyID() {
        return this.ontologyID;
    }

    public void finalize() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private class LoggerDaemon
    implements Runnable {
        private LoggerDaemon() {
        }

        @Override
        public void run() {
            try {
                while (AsynchronousLogger.this.conn != null) {
                    LogInfo entry = (LogInfo)AsynchronousLogger.this.logQueue.take();
                    this.writeDB(entry);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void writeDB(LogInfo entry) {
            try {
                AsynchronousLogger.this.fillInInsertCmd(entry);
                AsynchronousLogger.this.insertCmd.execute();
            }
            catch (Throwable e) {
                logger.error((Object)(AsynchronousLogger.this.loggerName + " failed to log an entry, possible communication failure. Will try to re-open connection."));
                if (AsynchronousLogger.this.conn != null) {
                    try {
                        AsynchronousLogger.this.conn.close();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                AsynchronousLogger.this.conn = null;
                int retries = 0;
                while (AsynchronousLogger.this.conn == null && retries < 10) {
                    ++retries;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    AsynchronousLogger.this.connectDB(true);
                }
                if (AsynchronousLogger.this.conn != null) {
                    logger.info((Object)(AsynchronousLogger.this.loggerName + " re-acquired database connection."));
                    AsynchronousLogger.this.setInsertCmd();
                    this.writeDB(entry);
                }
                logger.error((Object)(AsynchronousLogger.this.loggerName + " failed to re-acquire database connection after " + 10 + " attempts. Stopping logger."));
                AsynchronousLogger.this.logQueue.clear();
            }
        }
    }
}

