package org.eaglei.search.logging;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.ResourceProvider;
import org.eaglei.search.provider.SearchRequest.Term;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.security.Session;

public class AsynchronousLoggerSearch extends AsynchronousLogger {

	public static final int ROW_UUID_COL 			= 1;
	public static final int SESSIONID_COL 			= 2;
	public static final int USERID_COL 				= 3;
	public static final int USERINSTITUTION_COL 	= 4;
	public static final int DATE_COL 				= 5;
	public static final int START_COL 				= 6;
	public static final int END_COL 				= 7;
	public static final int DURATION_COL 			= 8;
	public static final int REQUEST_COL 			= 9;
	public static final int COUNT_COL 				= 10;
	public static final int TERMQUERY_COL 			= 11;
	public static final int TERMURI_COL 			= 12;
	public static final int TYPEURI_COL 			= 13;
	public static final int INSTITUTION_COL 		= 14;
	public static final int RESPROVINST_COL 		= 15;
	public static final int RESPROVTYPE_COL 		= 16;
	public static final int RESPROVURI_COL 			= 17;
	public static final int BUILDID_COL 			= 18;
	public static final int ONTOLOGYID_COL 			= 19;
	
	public AsynchronousLoggerSearch(String tname, String buildVersion,
			String ontVersion) {
		super(tname, buildVersion, ontVersion);
	}

	// Create table for log entries, if it does not exist.
	protected void createTable() {
		if (tableName == null) {
			logger.error("Table name was null.");
			conn = null;
			return;
		}
		if (tableName.trim().length() == 0) {
			logger.error("Table name was empty.");
			conn = null;
			return;
		}
		
		String createTableCmd = "CREATE TABLE IF NOT EXISTS " + tableName.trim() + " (" + 
			"op_id varchar(128) character set ascii NOT NULL," +  
			"session_id varchar(128) character set ascii NOT NULL," +  
			"user_id varchar(128) character set ascii NOT NULL," + 
			"user_institution varchar(128) character set ascii NOT NULL," + 
			"date varchar(64) character set ascii NOT NULL," +
			"start bigint(20) NOT NULL," + 
			"end bigint(20) NOT NULL," + 
			"duration bigint(20) NOT NULL," + 
			"search_request varchar(256) character set ascii NOT NULL," + 
			"num_results bigint(20) NOT NULL," +
			"term_query varchar(256) character set ascii NOT NULL," + 
			"term_uri varchar(256) character set ascii NOT NULL," + 
			"type_binding_uri varchar(256) character set ascii NOT NULL," + 
			"request_institution varchar(256) character set ascii NOT NULL," + 
			"res_prov_institution varchar(256) character set ascii NOT NULL," + 
			"res_prov_type varchar(256) character set ascii NOT NULL," + 
			"res_prov_uri varchar(256) character set ascii NOT NULL," + 
			"build_id varchar(128) character set ascii NOT NULL," + 
			"ontology_id varchar(128) character set ascii NOT NULL" +
			") ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		
		try {
			PreparedStatement createStmt = conn.prepareStatement(createTableCmd);
			createStmt.execute();
		} catch (SQLException e) {
			logger.error("Asynchronous logger failed to create table " + tableName);
			e.printStackTrace();
			try {
				conn.close();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			conn = null;
			return;
		}
	}
	
	// Create a PreparedStatement to insert a row into the table.
	protected void setInsertCmd() {
		if (conn != null) {
			String INSERT_CMD = "INSERT INTO " + tableName + " ( " + 
				"op_id, session_id, user_id, user_institution, date, start, end, " + 
				"duration, search_request, num_results, " +
				"term_query, term_uri, type_binding_uri," +
				"request_institution, res_prov_institution, res_prov_type, res_prov_uri," +
				"build_id, ontology_id ) VALUES ( " +
				"?, " + // op_id
				"?, " + // session_id
				"?, " + // user_id
				"?, " + // user_institution
				"?, " + // date
				"?, " + // start
				"?, " + // end
				"?, " + // duration
				"?, " + // search_request
				"?, " + // num_results
				"?, " + // term_query
				"?, " + // term_uri
				"?, " + // type_binding_uri
				"?, " + // request_institution
				"?, " + // res_prov_institution
				"?, " + // res_prov_type
				"?, " + // res_prov_uri
				"?, " + // build_id
				"?"     // ontology_id
				+ " );";
			try {
				insertCmd = conn.prepareStatement(INSERT_CMD);
			} catch (SQLException e) {
				logger.error("Asynchronous Logger failed to create insert command");
				e.printStackTrace();
				try {
					conn.close();
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
				conn = null;
			}
		}
	}
	
	// Fill the insert command with data for a new row.
	protected void fillInInsertCmd(LogInfo entryArg) {
		if ( !(entryArg instanceof LogInfoSearch) ) {
			logger.error("Incorrect LogInfo type");
			return;
		}
		
		LogInfoSearch entry = (LogInfoSearch) entryArg;
		
		try {
			UUID opid = UUID.randomUUID();
			long end = entry.getEnd();
			long duration = end - entry.getStart();
			
			// Detailed info
			String termQueryStr = "null";
			String termUriStr = "null";
			String typeUriStr = "null";
			String institutionStr = "null";
			String rpInstStr = "null";
			String rpTypeStr = "null";
			String rpUriStr = "null";
			SearchRequest request = entry.getRequest();
			Term term = request.getTerm();
			if (term != null) {
				if (term.getQuery() != null) {
					termQueryStr = term.getQuery();
				}
				if (term.getURI() != null) {
					termUriStr = term.getURI().toString();
				}				
			}
			TypeBinding typeBinding = request.getBinding();
			if (typeBinding != null) {
				if (typeBinding.getType() != null) {
					typeUriStr = typeBinding.getType().toString();
				}
			}
			EIURI institution = request.getProviderInstitution();
			if (institution != null) {
				institutionStr = institution.toString();
			}
			ResourceProvider resourceProvider = request.getProvider();
			if (resourceProvider != null) {
				if (resourceProvider.getInstitution() != null) {
					rpInstStr = resourceProvider.getInstitution().toString();
				}
				if (resourceProvider.getType() != null) {
					rpTypeStr = resourceProvider.getType().toString();
				}
				if (resourceProvider.getURI() != null) {
					rpUriStr = resourceProvider.getURI().toString();
				}
			}
			
			String date = dateFormat.format(new Date(end));
			//System.out.println("Date:  " + date);
			
			insertCmd.setString(ROW_UUID_COL, opid.toString());
			insertCmd.setString(SESSIONID_COL, entry.getSessionID());
			insertCmd.setString(USERID_COL, entry.getUserID());
			insertCmd.setString(USERINSTITUTION_COL, entry.getUserInstitution());
			insertCmd.setString(DATE_COL, date);
			insertCmd.setLong(START_COL, entry.getStart());
			insertCmd.setLong(END_COL, entry.getEnd());
			insertCmd.setLong(DURATION_COL, duration);
			insertCmd.setString(REQUEST_COL, entry.getRequest().toString());
			insertCmd.setLong(COUNT_COL, entry.getCount());
			insertCmd.setString(TERMQUERY_COL, termQueryStr);
			insertCmd.setString(TERMURI_COL, termUriStr);
			insertCmd.setString(TYPEURI_COL, typeUriStr);
			insertCmd.setString(INSTITUTION_COL, institutionStr);
			insertCmd.setString(RESPROVINST_COL, rpInstStr);
			insertCmd.setString(RESPROVTYPE_COL, rpTypeStr);
			insertCmd.setString(RESPROVURI_COL, rpUriStr);
			insertCmd.setString(BUILDID_COL, entry.getBuildID());
			insertCmd.setString(ONTOLOGYID_COL, entry.getOntologyID());
			
			//System.out.println("INSERT COMMAND:  " + insertCmd.toString());
		} catch (SQLException sqle) {
			logger.error("AsynchronousLogger failed to fill in insert command: " + insertCmd.toString());
		}
	}
	
	public void log(Session session, long start, long end,
			SearchRequest request, long count) {
		super.log(new LogInfoSearch(session, start, end, request, count, buildID, ontologyID));
}

}
