package org.eaglei.search.logging;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LogInfo {

	protected static final Log logger = LogFactory.getLog(LogInfo.class);	
	
	private static MessageDigest hashFunction = null;
	
	protected static final String NOT_RECORDED = "Not recorded";
	protected static final String NOT_AVAILABLE = "Not available";
	
	LogInfo() {
		getHashFunction();
	}
	
	public final String oneWayHash(String s) {
		
		if (hashFunction == null) {
			return NOT_RECORDED;
		}
		
		byte[] bytes;
		try {
			bytes = s.getBytes("UTF-8");
		} catch (UnsupportedEncodingException e) {
			bytes = s.getBytes();
		}
		byte[] hash = hashFunction.digest(bytes);
		
		return getHexString(hash);
	}
	
	private final synchronized void getHashFunction() {
		if ((hashFunction == null)) {
			
			try {
				hashFunction = MessageDigest.getInstance("MD5");
			} catch (NoSuchAlgorithmException e) {
				hashFunction = null;
			}		
			
			if (hashFunction == null) {
				logger.error("AsychronousLogger could not find a suitable hash function. User identities will be logged as 'Not recorded'");
			} 
		}
	}
	
	private String getHexString(byte[] bytes) {
		  String result = "";
		  for (int i=0; i < bytes.length; i++) {
		    result +=
		          Integer.toString( ( bytes[i] & 0xff ) + 0x100, 16).substring( 1 );
		  }
		  return result;
	}

	
}
