package org.eaglei.search.logging;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.security.Session;

public class LogInfoInstance extends LogInfo {

	private String sessionID;
	private String userID;
	private String userInstitution;
	private long start;
	private long end;
	private String instanceID;
	private String instanceClass;
	private String instanceLabel;
	private String instanceType;
	private String buildID;
	private String ontologyID;
	
	public LogInfoInstance(Session session, long start, long end,
			String instanceID, String instanceClass, String instanceLabel, String instanceType,
			String buildID, String ontologyID) {
		super();
		this.sessionID = session.getSessionId();
		this.userID = oneWayHash(session.getUserURI());
		this.userInstitution = session.getInstitutionId();
		if (userInstitution == null) {
			userInstitution = NOT_AVAILABLE;
		}
		this.start = start;
		this.end = end;
		this.instanceID = instanceID;
		this.instanceClass = instanceClass;
		this.instanceLabel = instanceLabel;
		this.instanceType = instanceType;
		this.buildID = buildID;
		this.ontologyID = ontologyID;
	}

	public String getSessionID() {
		return sessionID;
	}

	public String getUserID() {
		return userID;
	}
	
	public String getUserInstitution() {
		return userInstitution;
	}

	public long getStart() {
		return start;
	}

	public long getEnd() {
		return end;
	}

	public String getInstanceID() {
		return instanceID;
	}
	
	public String getInstanceClass() {
		return instanceClass;
	}
	
	public String getInstanceLabel() {
		return instanceLabel;
	}
	
	public String getInstanceType() {
		return instanceType;
	}
	
	public String getBuildID() {
		return buildID;
	}
	
	public String getOntologyID() {
		return ontologyID;
	}
}
