/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;

public class SearchResultRankMerger
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(SearchResultRankMerger.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String TRIM_TO_RANGE_PROP = "search.provider.merger.trim.to.range";
    public static final String DEFAULT_TRIM_TO_RANGE_PROP = "true";
    public static final float POSITION_DECREMENT = 1.0E-4f;
    private MultiNodeSearchProvider nestedProvider;
    private boolean trimToRange = true;

    public SearchResultRankMerger(MultiNodeSearchProvider nestedProvider) {
        this.nestedProvider = nestedProvider;
        String trimToRange = System.getProperty(TRIM_TO_RANGE_PROP, DEFAULT_TRIM_TO_RANGE_PROP);
        this.setTrimToRange(Boolean.parseBoolean(trimToRange));
    }

    public void setTrimToRange(boolean trimToRange) {
        this.trimToRange = trimToRange;
    }

    public boolean getTrimToRange() {
        return this.trimToRange;
    }

    public void init() throws IOException {
        this.nestedProvider.init();
    }

    public SearchCounts count(SearchCountRequest request) throws IOException {
        Collection counts = this.nestedProvider.count(request);
        SearchCounts aggregatedCounts = new SearchCounts(request.getRequest());
        for (SearchCounts count : counts) {
            for (EIURI uri : count.getClassesForCounts()) {
                int countForClass = count.getClassCount(uri);
                aggregatedCounts.setClassCount(uri, aggregatedCounts.getClassCount(uri) + countForClass);
            }
        }
        return aggregatedCounts;
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        int startIndex = request.getStartIndex();
        int maxResults = request.getMaxResults();
        request.setStartIndex(0);
        request.setMaxResults(startIndex + request.getMaxResults());
        Collection results = this.nestedProvider.query(request);
        request.setStartIndex(startIndex);
        request.setMaxResults(maxResults);
        return this.merge(results, request);
    }

    private SearchResultSet merge(Collection<SearchResultSet> results, SearchRequest request) {
        SearchResultSet merged = null;
        if (results.size() == 1) {
            if (DEBUG) {
                logger.debug((Object)"Collection only included one SearchResultSet, returning that");
            }
            merged = results.iterator().next();
        } else {
            if (results.size() == 0) {
                if (DEBUG) {
                    logger.debug((Object)"Collection was empty returning empty SearchResultSet");
                }
                SearchResultSet empty = new SearchResultSet(request);
                empty.setTotalCount(0);
                return empty;
            }
            merged = new SearchResultSet(request);
            List mergedResults = merged.getResults();
            TreeSet<SearchResult> sortedResults = new TreeSet<SearchResult>();
            boolean start = false;
            for (SearchResultSet resultSet : results) {
                if (DEBUG && resultSet.getResults().size() > 0) {
                    logger.debug((Object)("Merging result set with " + resultSet.getResults().size() + " results and start " + resultSet.getStartIndex()));
                }
                merged.setTotalCount(merged.getTotalCount() + resultSet.getTotalCount());
                int i = 1;
                for (SearchResult result : resultSet.getResults()) {
                    float rank = result.getRank();
                    result.setRank(rank -= (float)i++ * 1.0E-4f);
                    if (sortedResults.add(result)) continue;
                    merged.setTotalCount(merged.getTotalCount() - 1);
                }
            }
            for (SearchResult result : sortedResults) {
                merged.getResults().add(result);
            }
        }
        if (this.getTrimToRange()) {
            return this.trimToRange(merged, request);
        }
        return merged;
    }

    private SearchResultSet trimToRange(SearchResultSet results, SearchRequest request) {
        if (DEBUG) {
            logger.debug((Object)("Trimming to range " + request.getStartIndex() + " to " + (request.getStartIndex() + request.getMaxResults())));
        }
        SearchResultSet trimmed = new SearchResultSet(request);
        trimmed.setStartIndex(request.getStartIndex());
        trimmed.setTotalCount(results.getTotalCount());
        List list = results.getResults();
        int numToRemoveOnFront = request.getStartIndex() - results.getStartIndex();
        if (numToRemoveOnFront < 0) {
            numToRemoveOnFront = 0;
        }
        for (int i = numToRemoveOnFront; i < numToRemoveOnFront + request.getMaxResults() && i < list.size(); ++i) {
            SearchResult result = (SearchResult)list.get(i);
            trimmed.getResults().add(result);
        }
        return trimmed;
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        return null;
    }
}

