/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import org.eaglei.model.EIURI;
import org.eaglei.search.logging.AsynchronousLogger;
import org.eaglei.search.logging.LogInfo;
import org.eaglei.search.logging.LogInfoContact;

public class AsynchronousLoggerContact
extends AsynchronousLogger {
    public static final int ROW_UUID_COL = 1;
    public static final int SESSIONID_COL = 2;
    public static final int CLIENT_IP_COL = 3;
    public static final int INSTANCEID_COL = 4;
    public static final int DATE_COL = 5;
    public static final int LABEL_COL = 6;
    public static final int FROM_NAME_COL = 7;
    public static final int FROM_EMAIL_COL = 8;
    public static final int SUBJECT_COL = 9;
    public static final int BUILDID_COL = 10;
    public static final int ONTOLOGYID_COL = 11;

    public AsynchronousLoggerContact(String tname, String buildVersion, String ontVersion) {
        super(tname, buildVersion, ontVersion);
    }

    @Override
    protected void createTable() {
        if (this.tableName == null) {
            logger.error((Object)"Table name was null.");
            this.conn = null;
            return;
        }
        if (this.tableName.trim().length() == 0) {
            logger.error((Object)"Table name was empty.");
            this.conn = null;
            return;
        }
        String createTableCmd = "CREATE TABLE IF NOT EXISTS " + this.tableName.trim() + " (" + "op_id varchar(128) character set ascii NOT NULL," + "session_id varchar(128) character set ascii NOT NULL," + "client_ip varchar(128) character set ascii NOT NULL," + "instance_id varchar(128) character set ascii NOT NULL," + "date varchar(64) character set ascii NOT NULL," + "label varchar(128) character set ascii NOT NULL," + "from_name varchar(128) character set ascii NOT NULL," + "from_email varchar(128) character set ascii NOT NULL," + "subject varchar(128) character set ascii NOT NULL," + "build_id varchar(128) character set ascii NOT NULL," + "ontology_id varchar(128) character set ascii NOT NULL" + ") ENGINE=MyISAM DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement createStmt = this.conn.prepareStatement(createTableCmd);
            createStmt.execute();
        }
        catch (SQLException e) {
            logger.error((Object)("Asynchronous logger failed to create table " + this.tableName));
            e.printStackTrace();
            try {
                this.conn.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            this.conn = null;
            return;
        }
    }

    @Override
    protected void fillInInsertCmd(LogInfo entryArg) {
        if (!(entryArg instanceof LogInfoContact)) {
            logger.error((Object)"Incorrect LogInfo type");
            return;
        }
        LogInfoContact entry = (LogInfoContact)entryArg;
        try {
            UUID opid = UUID.randomUUID();
            String date = this.dateFormat.format(new Date(System.currentTimeMillis()));
            this.insertCmd.setString(1, opid.toString());
            this.insertCmd.setString(2, entry.getSessionID());
            this.insertCmd.setString(3, entry.getClientIP());
            this.insertCmd.setString(4, entry.getInstanceID());
            this.insertCmd.setString(5, date);
            this.insertCmd.setString(6, entry.getLabel());
            this.insertCmd.setString(7, entry.getFromName());
            this.insertCmd.setString(8, entry.getFromEmail());
            this.insertCmd.setString(9, entry.getSubject());
            this.insertCmd.setString(10, entry.getBuildID());
            this.insertCmd.setString(11, entry.getOntologyID());
        }
        catch (SQLException sqle) {
            logger.error((Object)("AsynchronousLogger failed to fill in insert command: " + this.insertCmd.toString()));
        }
    }

    @Override
    protected void setInsertCmd() {
        if (this.conn != null) {
            String INSERT_CMD = "INSERT INTO " + this.tableName + " ( " + "op_id, session_id, client_ip, " + " instance_id," + " date, label, from_name, from_email, subject," + " build_id, ontology_id ) VALUES ( " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?, " + "?" + " );";
            try {
                this.insertCmd = this.conn.prepareStatement(INSERT_CMD);
            }
            catch (SQLException e) {
                logger.error((Object)"Asynchronous Logger failed to create insert command");
                e.printStackTrace();
                try {
                    this.conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                this.conn = null;
            }
        }
    }

    public void log(String session, String clientIP, EIURI instanceIDuri, String label, String from_name, String from_email, String subject) {
        String instanceID = instanceIDuri.toString();
        super.log(new LogInfoContact(session, clientIP, instanceID, from_name, from_email, label, subject, this.buildID, this.ontologyID));
    }
}

