package org.eaglei.search.logging;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;

import org.eaglei.model.EIURI;

public class AsynchronousLoggerContact extends AsynchronousLogger {

	public static final int ROW_UUID_COL 			= 1;
	public static final int SESSIONID_COL 			= 2;
	public static final int CLIENT_IP_COL			= 3;
	public static final int INSTANCEID_COL 			= 4;
	public static final int DATE_STRING_COL			= 5;
	public static final int DATE_COL				= 6;
	public static final int LABEL_COL				= 7;
	public static final int FROM_NAME_COL			= 8;
	public static final int FROM_EMAIL_COL			= 9;
	public static final int SUBJECT_COL				= 10;
	public static final int BUILDID_COL 			= 11;
	public static final int ONTOLOGYID_COL 			= 12;
	
	public AsynchronousLoggerContact(String tname, String buildVersion,
			String ontVersion) {
		super(tname, buildVersion, ontVersion);
	}
	
	@Override
	protected void createTable() {
		if (tableName == null) {
			logger.error("Table name was null.");
			conn = null;
			return;
		}
		if (tableName.trim().length() == 0) {
			logger.error("Table name was empty.");
			conn = null;
			return;
		}
		
		String createTableCmd = "CREATE TABLE IF NOT EXISTS " + tableName.trim() + " (" + 
			"op_id varchar(128) character set ascii PRIMARY KEY," +  
			"session_id varchar(128) character set ascii NOT NULL," +  
			"client_ip varchar(128) character set ascii NOT NULL," + 
			"instance_id varchar(128) character set ascii NOT NULL," +
			"date_string varchar(128) character set ascii NOT NULL," +
			"date datetime NOT NULL," +
			"label varchar(128) character set ascii NOT NULL," +
			"from_name varchar(128) character set ascii NOT NULL," +
			"from_email varchar(128) character set ascii NOT NULL," +
			"subject varchar(128) character set ascii NOT NULL," +
			"build_id varchar(128) character set ascii NOT NULL," + 
			"ontology_id varchar(128) character set ascii NOT NULL" +
			") ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		
		try {
			PreparedStatement createStmt = conn.prepareStatement(createTableCmd);
			createStmt.execute();
		} catch (SQLException e) {
			logger.error("Asynchronous logger failed to create table " + tableName);
			e.printStackTrace();
			try {
				conn.close();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			conn = null;
			return;
		}

	}

	@Override
	protected void fillInInsertCmd(LogInfo entryArg) {
		
		if ( !(entryArg instanceof LogInfoContact) ) {
			logger.error("Incorrect LogInfo type");
			return;
		}
		
		LogInfoContact entry = (LogInfoContact) entryArg;
		
		try {
			UUID opid = UUID.randomUUID();
			
			final long now = System.currentTimeMillis();
			final String date = dateFormat.format(new Date(now));
			
			insertCmd.setString(ROW_UUID_COL, opid.toString());
			insertCmd.setString(SESSIONID_COL, entry.getSessionID());
			insertCmd.setString(CLIENT_IP_COL, entry.getClientIP());
			insertCmd.setString(INSTANCEID_COL, entry.getInstanceID());
			insertCmd.setString(DATE_STRING_COL, date);
			insertCmd.setTimestamp( DATE_COL, new Timestamp(now));
			insertCmd.setString(LABEL_COL, entry.getLabel());
			insertCmd.setString(FROM_NAME_COL, entry.getFromName());
			insertCmd.setString(FROM_EMAIL_COL, entry.getFromEmail());
			insertCmd.setString(SUBJECT_COL, entry.getSubject());
			insertCmd.setString(BUILDID_COL, entry.getBuildID());
			insertCmd.setString(ONTOLOGYID_COL, entry.getOntologyID());
			
			//System.out.println("INSERT COMMAND:  " + insertCmd.toString());
		} catch (SQLException sqle) {
			logger.error("AsynchronousLogger failed to fill in insert command: " + insertCmd.toString());
		}

	}

	@Override
	protected void setInsertCmd() {
		
		if (conn != null) {
			String INSERT_CMD = "INSERT INTO " + tableName + " ( " + 
				"op_id, session_id, client_ip, " +
				" instance_id, date_string," +
				" date, label, from_name, from_email, subject," +
				" build_id, ontology_id ) VALUES ( " +
				"?, " + // op_id
				"?, " + // session_id
				"?, " + // client_ip
				"?, " + // instance_id
				"?, " + // date_string
				"?, " + // date
				"?, " + // label
				"?, " + // from_name
				"?, " + // from_email
				"?, " + // subject
				"?, " + // build_id
				"?"     // ontology_id
				+ " );";
			try {
				insertCmd = conn.prepareStatement(INSERT_CMD);
			} catch (SQLException e) {
				logger.error("Asynchronous Logger failed to create insert command");
				e.printStackTrace();
				try {
					conn.close();
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
				conn = null;
			}
		}

	}

	public void log(String session, 
    		String clientIP, EIURI instanceIDuri, String label, String from_name,
    		String from_email, String subject) {
		String instanceID = instanceIDuri.toString();
		
		super.log(new LogInfoContact(session, clientIP, instanceID, 
				from_name, from_email, label, subject,
				buildID, ontologyID));
	}
}
