package org.eaglei.search.logging;

public class LogInfoContact extends LogInfo {

	private String sessionID;
	private String clientIP;
	private String instanceID;
	private String fromName;
	private String fromEmail;
	private String label;
	private String subject;
	private String buildID;
	private String ontologyID;
	
	public LogInfoContact(String session, String clientIP,
			String instanceID, 
			String fromName, String fromEmail, String label, String subject,
			String buildID, String ontologyID) {
		super();
		this.sessionID = checkForNull(session);
		this.clientIP = checkForNull(clientIP);
		this.instanceID = checkForNull(instanceID);
		this.fromName = checkForNull(fromName);
		this.fromEmail = checkForNull(fromEmail);
		this.label = checkForNull(label);
		this.subject = checkForNull(subject);
		this.buildID = checkForNull(buildID);
		this.ontologyID = checkForNull(ontologyID);
	}

	public String getSessionID() {
		return sessionID;
	}

	public String getClientIP() {
		return clientIP;
	}

	public String getInstanceID() {
		return instanceID;
	}

	public String getFromName() {
		return fromName;
	}

	public String getFromEmail() {
		return fromEmail;
	}

	public String getLabel() {
		return label;
	}

	public String getSubject() {
		return subject;
	}

	public String getBuildID() {
		return buildID;
	}

	public String getOntologyID() {
		return ontologyID;
	}

	public String toString() {
		String s = new String();
		
		s = "Session ID: " + sessionID + " clientIP: " + clientIP + " instanceID: " +
			" fromName: " + fromName + " fromEmail: " + fromEmail + " label: " + label +
			" subject: " + subject + " buildID: " + buildID + " ontologyID: " + ontologyID;
		
		return s;
	}
}
