package org.eaglei.search.logging;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.security.Session;

public class LogInfoCount extends LogInfo {
	private String sessionID;
	private String userID;
	private String userInstitution;
	private long start;
	private long end;
	private SearchRequest request;
	private String buildID;
	private String ontologyID;
	
	public LogInfoCount(Session session, long start, long end,
			SearchRequest request, String buildID, String ontologyID) {
		super();
		
		this.sessionID = checkForNull(session.getSessionId());
		this.userID = oneWayHash(checkForNull(session.getUserURI()));
		this.userInstitution = session.getInstitutionId();
		if (userInstitution == null) {
			userInstitution = NOT_AVAILABLE;
		}
		this.start = start;
		this.end = end;
		this.request = request;
		this.buildID = checkForNull(buildID);
		this.ontologyID = checkForNull(ontologyID);
	}

	public String getSessionID() {
		return sessionID;
	}

	public String getUserID() {
		return userID;
	}
	
	public String getUserInstitution() {
		return userInstitution;
	}

	public long getStart() {
		return start;
	}

	public long getEnd() {
		return end;
	}

	public SearchRequest getRequest() {
		return request;
	}

	public String getBuildID() {
		return buildID;
	}
	
	public String getOntologyID() {
		return ontologyID;
	}
	
	public String toString() {
		String s = new String();
		
		s = "sessionID: " + sessionID + " userID: " + userID + " userInstitution: " + userInstitution +
		    " start: " + start + " end: " + end + " request: " + request.toString() + " buildID: " + buildID +
		    " ontologyID: " + ontologyID;
		
		return s;
	}
}
