package org.eaglei.search.logging;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.security.Session;

public class LogInfoSearch extends LogInfo {

	private String sessionID;
	private String userID;
	private String userInstitution;
	private long start;
	private long end;
	private SearchRequest request;
	private long count;
	private String buildID;
	private String ontologyID;
	
	public LogInfoSearch(Session session, long start, long end,
			SearchRequest request, long count, String buildID, String ontologyID) {
		super();
		this.sessionID = checkForNull(session.getSessionId());
		this.userID = oneWayHash(checkForNull(session.getUserURI()));
		this.userInstitution = session.getInstitutionId();
		if (userInstitution == null) {
			userInstitution = NOT_AVAILABLE;
		}
		this.start = start;
		this.end = end;
		this.request = request;
		this.count = count;
		this.buildID = checkForNull(buildID);
		this.ontologyID = checkForNull(ontologyID);
	}

	public String getSessionID() {
		return sessionID;
	}

	public String getUserID() {
		return userID;
	}

	public String getUserInstitution() {
		return userInstitution;
	}

	public long getStart() {
		return start;
	}

	public long getEnd() {
		return end;
	}

	public SearchRequest getRequest() {
		return request;
	}
	
	public long getCount() {
		return count;
	}

	public String getBuildID() {
		return buildID;
	}
	
	public String getOntologyID() {
		return ontologyID;
	}
	
	public String toString() {
		String s = new String();
		
		s = "sessionID: " + sessionID + " userID: " + userID + " userInstitution: " + userInstitution +
		    " start: " + start + " end: " + end + " request: " + request.toString() + " count: " + count +
		    " buildID: " + buildID + " ontologyID: " + ontologyID;
		
		return s;
	}
}
