/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import org.eaglei.search.logging.LogInfo;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.security.Session;

public class LogInfoSearch
extends LogInfo {
    private String sessionID;
    private String userID;
    private String userInstitution;
    private long start;
    private long end;
    private SearchRequest request;
    private long count;
    private String buildID;
    private String ontologyID;

    public LogInfoSearch(Session session, long start, long end, SearchRequest request, long count, String buildID, String ontologyID) {
        this.sessionID = this.checkForNull(session.getSessionId());
        this.userID = this.oneWayHash(this.checkForNull(session.getUserURI()));
        this.userInstitution = session.getInstitutionId();
        if (this.userInstitution == null) {
            this.userInstitution = "Not available";
        }
        this.start = start;
        this.end = end;
        this.request = request;
        this.count = count;
        this.buildID = this.checkForNull(buildID);
        this.ontologyID = this.checkForNull(ontologyID);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserInstitution() {
        return this.userInstitution;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public SearchRequest getRequest() {
        return this.request;
    }

    public long getCount() {
        return this.count;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public String getOntologyID() {
        return this.ontologyID;
    }

    @Override
    public String toString() {
        String s = new String();
        s = "sessionID: " + this.sessionID + " userID: " + this.userID + " userInstitution: " + this.userInstitution + " start: " + this.start + " end: " + this.end + " request: " + this.request.toString() + " count: " + this.count + " buildID: " + this.buildID + " ontologyID: " + this.ontologyID;
        return s;
    }
}

