/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderFactory;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;

public final class CompositeLuceneProviderFactory
implements SearchProviderFactory {
    private static final Log logger = LogFactory.getLog(CompositeLuceneProviderFactory.class);
    public static final String NESTED_PROVIDER_FACTORY_PROP = "search.provider.composite.nested.provider.factory.class";

    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException {
        String nestedProviderFactoryClass = config.getProperties().getProperty(NESTED_PROVIDER_FACTORY_PROP);
        if (nestedProviderFactoryClass == null) {
            throw new IOException("Nested provider factory class property not set");
        }
        try {
            Class<?> factoryClass = Class.forName(nestedProviderFactoryClass);
            SearchProviderFactory factory = (SearchProviderFactory)factoryClass.newInstance();
            SearchProvider nestedProvider = factory.createSearchProvider(config);
            return new CompositeLuceneProvider(nestedProvider);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

