/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.request.SearchResult;

public class LuceneIndexer {
    private static final Log logger = LogFactory.getLog(LuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String URI = "uri";
    public static final String TEXT = "text";
    public static final String INFERRED_TYPE = "inferredType";
    public static final String INSTITUTION_URI = "institution_uri";
    public static final String INSTITUTION_LABEL = "institution_label";
    private Analyzer analyzer;
    private Directory directory;
    private IndexWriter iwriter;
    private Set<EIURI> keys = new HashSet<EIURI>();

    public LuceneIndexer(Analyzer analyzer, Directory directory) {
        this.analyzer = analyzer;
        this.directory = directory;
    }

    public void initializeStorage() throws IOException {
        this.iwriter = new IndexWriter(this.directory, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
    }

    public void closeStorage() throws IOException {
        if (DEBUG) {
            logger.debug((Object)("Saving " + this.iwriter.numDocs() + " to Lucene index"));
        }
        this.iwriter.optimize();
        this.iwriter.close();
        this.keys = null;
    }

    public void indexSearchResult(SearchResult result, boolean materializeTypes) throws IOException {
        Set values;
        EIURI uri = result.getEntity().getURI();
        if (!this.isUnique(uri)) {
            logger.warn((Object)("Trying to add duplicate URI: " + uri));
            return;
        }
        Document doc = new Document();
        doc.add((Fieldable)new Field(URI, uri.toString(), Field.Store.YES, Field.Index.ANALYZED));
        EIEntity institutionEntity = result.getInstitution();
        doc.add((Fieldable)new Field(INSTITUTION_URI, institutionEntity.getURI().toString(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(INSTITUTION_LABEL, institutionEntity.getLabel(), Field.Store.YES, Field.Index.ANALYZED));
        OntModel model = JenaEIOntModel.INSTANCE.getOntModel();
        for (EIURI propURI : result.getDataTypeProperties()) {
            values = result.getDataTypeProperty(propURI);
            for (String value : values) {
                doc.add((Fieldable)new Field(propURI.toString(), value.toString(), Field.Store.YES, Field.Index.ANALYZED));
                doc.add((Fieldable)new Field(TEXT, value, Field.Store.YES, Field.Index.ANALYZED));
            }
        }
        for (EIURI propURI : result.getObjectProperties()) {
            values = result.getObjectProperty(propURI);
            for (String value : values) {
                doc.add((Fieldable)new Field(propURI.toString(), value.toString(), Field.Store.YES, Field.Index.ANALYZED));
            }
        }
        EIEntity typeEntity = result.getType();
        doc.add((Fieldable)new Field(RDF.type.getURI(), typeEntity.getURI().toString(), Field.Store.YES, Field.Index.ANALYZED));
        OntClass resourceClass = model.getOntClass(typeEntity.getURI().toString());
        if (resourceClass == null) {
            logger.error((Object)("Null OntClass for " + typeEntity));
        }
        for (OntClass type : AbstractGenerator.getTypes((OntClass)resourceClass, (boolean)materializeTypes)) {
            doc.add((Fieldable)new Field(INFERRED_TYPE, type.getURI(), Field.Store.YES, Field.Index.ANALYZED));
            String label = JenaEIOntModel.INSTANCE.getPreferredLabel(EIURI.create((String)type.getURI()));
            if (label == null) continue;
            doc.add((Fieldable)new Field(TEXT, label, Field.Store.YES, Field.Index.ANALYZED));
        }
        this.iwriter.addDocument(doc);
    }

    private boolean isUnique(EIURI uri) {
        if (this.keys.contains(uri)) {
            return false;
        }
        this.keys.add(uri);
        return true;
    }
}

