/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public final class LuceneProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(LuceneProvider.class);
    private final Directory dir;
    private final Analyzer analyzer;
    private final IndexSearcher searcher;
    private final QueryParser institutionParser;
    private final QueryParser typeParser;
    private Collection<EIEntity> institutions = Collections.EMPTY_SET;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();

    public LuceneProvider(Directory dir, Analyzer analyzer) throws IOException {
        assert (dir != null);
        assert (analyzer != null);
        this.dir = dir;
        this.analyzer = analyzer;
        this.institutionParser = new QueryParser(Version.LUCENE_30, "institution_uri", this.analyzer);
        this.typeParser = new QueryParser(Version.LUCENE_30, "inferredType", this.analyzer);
        this.searcher = new IndexSearcher(this.dir, true);
        this.searcher.setDefaultFieldSortScoring(true, true);
        this.retrieveOntologyMetadata();
    }

    private void retrieveOntologyMetadata() {
        List props = JenaEIOntModel.INSTANCE.getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create((String)prop.getURI()));
        }
    }

    public synchronized void init() throws IOException {
        this.institutions = SearchProviderUtil.getInstitutions((SearchProvider)this);
    }

    public Collection<EIEntity> getInstitutions() {
        return this.institutions;
    }

    public synchronized SearchResultSet query(SearchRequest request) throws IOException {
        assert (request != null);
        Query query = null;
        try {
            query = this.createQuery(request);
        }
        catch (ParseException pe) {
            throw new IOException(pe.getLocalizedMessage());
        }
        if (query == null) {
            return new SearchResultSet(request);
        }
        return this.executeSearch(request, query);
    }

    private SearchResultSet executeSearch(SearchRequest request, Query query) throws IOException {
        SearchResultSet results = new SearchResultSet(request);
        TopFieldDocs docs = this.searcher.search(query, null, request.getStartIndex() + request.getMaxResults(), Sort.RELEVANCE);
        logger.debug((Object)("Found " + docs.totalHits + " matches"));
        results.setTotalCount(docs.totalHits);
        results.setStartIndex(request.getStartIndex());
        Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
        int cap = request.getStartIndex() + request.getMaxResults();
        for (int i = request.getStartIndex(); i < cap && i < docs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = docs.scoreDocs[i];
            Document document = this.searcher.doc(scoreDoc.doc);
            float score = scoreDoc.score;
            String resource = document.get("uri");
            String label = null;
            for (EIURI prop : this.prefLabelProperties) {
                String[] values = document.getValues(prop.toString());
                if (values.length <= 0) continue;
                label = values[0];
                break;
            }
            EIEntity resourceEntity = EIEntity.create((EIURI)EIURI.create((String)resource), label);
            String institution_uri = document.get("institution_uri");
            String institution_label = document.get("institution_label");
            EIEntity institutionEntity = EIEntity.create((EIURI)EIURI.create((String)institution_uri), (String)institution_label);
            String type = document.get(RDF.type.getURI());
            if (type == null) {
                logger.error((Object)("Null rdf:type for " + resource));
                continue;
            }
            EIClass eiClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create((String)type));
            if (eiClass == null) {
                logger.error((Object)("Unable to locate resource class " + type + " for " + resource));
                continue;
            }
            SearchResult result = new SearchResult(resourceEntity, eiClass.getEntity(), null, institutionEntity);
            String highlight = this.computeHighlight(highlighter, request, query, document);
            if (highlight != null) {
                result.setHighlight(highlight);
            }
            result.setURL(resource);
            result.setRank(score);
            if (results.getResults().contains(result)) {
                logger.error((Object)"Found duplicate result");
            }
            results.getResults().add(result);
        }
        return results;
    }

    private String computeHighlight(Highlighter highlighter, SearchRequest request, Query query, Document document) {
        String highlight = null;
        SearchRequest.Term term = request.getTerm();
        if (term != null && term.getQuery() != null) {
            Field[] texts;
            for (Field field : texts = document.getFields("text")) {
                String text = field.stringValue();
                try {
                    highlight = highlighter.getBestFragment(this.analyzer, "text", text);
                    if (highlight == null) continue;
                    break;
                }
                catch (InvalidTokenOffsetsException itoe) {
                    logger.error((Object)itoe);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                }
            }
        }
        return highlight;
    }

    private Query createQuery(SearchRequest request) throws ParseException {
        EIURI typeURI;
        SearchRequest.Term term = request.getTerm();
        SearchRequest.TypeBinding binding = request.getBinding();
        EIURI institution = request.getInstitution();
        BooleanQuery query = new BooleanQuery();
        if (institution != null) {
            Query institutionQuery = this.institutionParser.parse(QueryParser.escape((String)institution.toString()));
            query.add(institutionQuery, BooleanClause.Occur.MUST);
        }
        if (term != null && term.getQuery() != null) {
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> queries = new ArrayList<String>();
            ArrayList<BooleanClause.Occur> occurrence = new ArrayList<BooleanClause.Occur>();
            fields.add("text");
            queries.add(term.getQuery());
            occurrence.add(BooleanClause.Occur.SHOULD);
            Query termQuery = MultiFieldQueryParser.parse((Version)Version.LUCENE_30, (String[])queries.toArray(new String[queries.size()]), (String[])fields.toArray(new String[fields.size()]), (BooleanClause.Occur[])occurrence.toArray(new BooleanClause.Occur[occurrence.size()]), (Analyzer)this.analyzer);
            query.add(termQuery, BooleanClause.Occur.MUST);
        }
        if ((typeURI = SearchProviderUtil.getType((SearchRequest)request)) != null) {
            Query typeQuery = this.typeParser.parse(QueryParser.escape((String)typeURI.toString()));
            query.add(typeQuery, BooleanClause.Occur.MUST);
        }
        if (query.clauses().isEmpty()) {
            Query anyInstitutionQuery = this.institutionParser.parse("http*");
            query.add(anyInstitutionQuery, BooleanClause.Occur.SHOULD);
            return query;
        }
        return query;
    }
}

