/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.common.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderFactory;
import org.eaglei.search.provider.lucene.LuceneGenerator;
import org.eaglei.search.provider.lucene.LuceneProvider;

public final class LuceneProviderFactory
implements SearchProviderFactory {
    private static final Log logger = LogFactory.getLog(LuceneProviderFactory.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String LUCENE_INDEX_DIR_PROP = "search.provider.lucene.index.dir";

    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException {
        String indexDir;
        assert (config != null);
        if (DEBUG) {
            logger.debug((Object)"Initializing Lucene repo");
        }
        if ((indexDir = config.getProperties().getProperty(LUCENE_INDEX_DIR_PROP)) != null) {
            URL dirURL = this.getClass().getClassLoader().getResource(indexDir);
            if (dirURL != null) {
                if (DEBUG) {
                    logger.debug((Object)("Found Lucene index on classpath: " + dirURL));
                }
                try {
                    File dir = new File(dirURL.toURI());
                    return LuceneProviderFactory.createFileBasedRepo(null, dir);
                }
                catch (URISyntaxException urle) {
                    throw new IOException(urle);
                }
            }
            String msg = "Failed to find Lucene index dir " + indexDir + " on classpath, auto-generating in-memory index";
            logger.error((Object)msg);
        }
        if (DEBUG) {
            logger.debug((Object)"Auto-generating Lucene index in-memory");
        }
        DataGenParams params = DataGenParams.createForAllInstitutions();
        params.setCoreFacilityRange(5, 10);
        params.setResearchFacilityRange(0, 0);
        params.setMaterializeHierarchy(true);
        return LuceneProviderFactory.createInMemoryRepo(params);
    }

    public static SearchProvider createInMemoryRepo() throws IOException {
        return LuceneProviderFactory.createInMemoryRepo(DataGenParams.createForAllInstitutions());
    }

    public static SearchProvider createInMemoryRepo(DataGenParams params) throws IOException {
        assert (params != null);
        RAMDirectory dir = new RAMDirectory();
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        LuceneProviderFactory.populate(params, (Directory)dir, (Analyzer)analyzer);
        return new LuceneProvider((Directory)dir, (Analyzer)analyzer);
    }

    public static SearchProvider createFileBasedRepo(File genDir) throws IOException {
        return LuceneProviderFactory.createFileBasedRepo(DataGenParams.createForAllInstitutions(), genDir);
    }

    public static SearchProvider createFileBasedRepo(DataGenParams params, File genDir) throws IOException {
        assert (genDir != null);
        assert (genDir.isDirectory());
        boolean generate = false;
        if (!genDir.exists()) {
            genDir.mkdirs();
            generate = true;
        }
        FSDirectory dir = FSDirectory.open((File)genDir);
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        if (generate) {
            LuceneProviderFactory.populate(params, (Directory)dir, (Analyzer)analyzer);
        }
        return new LuceneProvider((Directory)dir, (Analyzer)analyzer);
    }

    private static void populate(DataGenParams params, Directory dir, Analyzer analyzer) throws IOException {
        LuceneGenerator generator = new LuceneGenerator(analyzer, dir);
        generator.generate(params);
    }
}

