package org.eaglei.search.provider.lucene.suggest;

import java.io.IOException;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.AutoSuggestIndexAnalyzer;
import org.eaglei.lexical.lucene.AutoSuggestQueryAnalyzer;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.lucene.AbstractStreamHarvester;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LuceneAutoSuggestConfig {

    @Autowired
    private EIOntModel eagleiOntModel;
    
    @Autowired
    private AbstractStreamHarvester dataHarvester;
    
    public @Bean Directory autoSuggestDirectory() {
        return new RAMDirectory();
    }

    public @Bean Analyzer autoSuggestIndexAnalyzer() {
        return new AutoSuggestIndexAnalyzer();
    }
    
    public @Bean Analyzer autoSuggestQueryAnalyzer() {
        return new AutoSuggestQueryAnalyzer();
    }
    
    public @Bean LuceneAutoSuggestIndexer autoSuggestIndexer() {
        LuceneAutoSuggestIndexer indexer = new LuceneAutoSuggestIndexer(eagleiOntModel, 
        		autoSuggestIndexAnalyzer(), autoSuggestDirectory());
        dataHarvester.addChangeListener(indexer);
        return indexer;
    }

    public @Bean LuceneAutoSuggestProvider autoSuggestProvider() throws IOException {    
        return new LuceneAutoSuggestProvider(autoSuggestQueryAnalyzer(), 
        		autoSuggestIndexAnalyzer(), autoSuggestDirectory());
    }    

}
