package org.eaglei.search.provider.lucene.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;

import com.hp.hpl.jena.vocabulary.RDF;

public class ClassUsageCache {

    private static final Log logger = LogFactory.getLog(ClassUsageCache.class);
    
    //private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    
    private final EIOntModel eiOntModel;
    //private int count;
    private HashMap<EIURI, ClassUsage> mapClassURIToUsage = new HashMap<EIURI, ClassUsage>();
    //private HashSet<EIEntity> indexedResources = new HashSet<EIEntity>();
    private final List<EIEntity> listPrimaryResources;

    
    public ClassUsageCache(EIOntModel eiOntModel) {
    	this.eiOntModel = eiOntModel;
    	List<EIClass> listDataModelCreateResources = eiOntModel.getClassesInGroup(EIOntConstants.CG_DATA_MODEL_CREATE);
    	this.listPrimaryResources = new ArrayList<EIEntity>(listDataModelCreateResources.size() + 1);
    	for (EIClass c : listDataModelCreateResources) {
        	listPrimaryResources.add(c.getEntity());
    	}
    	EIClass coreResource = eiOntModel.getClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000002"));
    	listPrimaryResources.add(coreResource.getEntity());
    }

    /*
    @Override
    public void onChangeStreamStart(EIEntity institution) {
        logger.debug("onChangeStreamStart");
        count = 0;
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        onChangeEventInternal(event, false);
    }
    
    private void onChangeEventInternal(ResourceChangeEvent event, boolean logUnknowns) {
    	if (event == null) {
    		logger.error("Null change event notification");
    		return;
    	}
    	count++;
    	if (count % 100 == 0) {
    		logger.debug("Received " + count + " change events...");
    	}
    	if (event.isDelete()) {
    		removeUsage(event.getType(), null, event);
    	} else {
    		//indexedResources.add(event.getEntity());
    		addUsage(event.getType(), null, event);
    	}
    }

    @Override
    public void onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        logger.debug("onChangeStreamEnd: num change events " + count + 
        		" last modifed: " + dateFormat.format(lastModifiedDate));
        //for (EIClass c : eiOntModel.getClassesInGroup(EIOntConstants.CG_RESOURCE_ROOT)) {
        //	ClassUsage usage = mapClassURIToUsage.get(c.getEntity().getURI());
        // 	logger.debug("   " + c.getEntity().getLabel() + "  (" + (usage != null ? usage.getTotalCount().getCount() : 0) + ")");
        //}
    }
	*/
    
    /*
     * Walk up the superclass hierarchy, removing usage count.
     * If subclassTypeEntity is non-null, that indicates that this
     * subclass has no members.
     */
    void removeUsage(EIEntity resourceTypeEntity, EIEntity subclassTypeEntity, 
    		ResourceChangeEvent event) {
    	ClassUsage classUsage = mapClassURIToUsage.get(resourceTypeEntity.getURI());
    	assert(classUsage != null) : "removeUsage called for a type that had no usage previously recorded: " + resourceTypeEntity + "  instance: " + event.getEntity();
    	classUsage.decrementUsage();  
    	if (classUsage.getTotalCount().getCount() == 0) {
        	mapClassURIToUsage.remove(resourceTypeEntity.getURI());
    	} else {
	    	if (subclassTypeEntity != null) {
	    		classUsage.removeSubClassUsage(subclassTypeEntity.getURI());
	    	}
    	}
    	EIClass resourceClass = eiOntModel.getClass(resourceTypeEntity.getURI());
    	EIClass resourceSuperClass = eiOntModel.getSuperClass(resourceClass);
    	if (resourceSuperClass != null) {
    		// If the count of this class has gone to zero, then pass this entity
    		// to the superclass usage processing, where it will be deleted from
    		// the subclass list.
    		removeUsage(resourceSuperClass.getEntity(), 
    				(classUsage.getTotalCount().getCount() == 0) ? resourceTypeEntity : null, event);
    	}    	
    }

    /*
     * Walk up the superclass hierarchy, adding usage count.
     */
    void addUsage(EIEntity resourceTypeEntity, EIEntity subclassTypeEntity, 
    		ResourceChangeEvent event) {
    	ClassUsage classUsage = mapClassURIToUsage.get(resourceTypeEntity.getURI());
    	if (classUsage == null) {
    		classUsage = new ClassUsage(resourceTypeEntity);
    		mapClassURIToUsage.put(resourceTypeEntity.getURI(), classUsage);
    	}
    	classUsage.incrementUsage();   
    	if (subclassTypeEntity != null) {
    		classUsage.addSubClassUsage(subclassTypeEntity.getURI());
    	}
    	EIClass resourceClass = eiOntModel.getClass(resourceTypeEntity.getURI());
    	EIClass resourceSuperClass = eiOntModel.getSuperClass(resourceClass);
    	if (resourceSuperClass != null) {
    		addUsage(resourceSuperClass.getEntity(), resourceTypeEntity, event);
    	}
    }
    
    public ClassCountResult getClassCount(SearchRequest request) {
        EIURI classURI = request.getBinding() != null ? request.getBinding().getType() : null;
    	if (classURI == null) {	    
    		// Null entity indicates the All count
    		return getPrimaryResourcesResult(request);
    	} else {
    		// An individual class result
    		return getClassResult(request);
    	}
    }
    
    private ClassCountResult getPrimaryResourcesResult(SearchRequest request) {
    	ClassCountResult result;
        EIURI classURI = request.getBinding() != null ? request.getBinding().getType() : null;
    	assert (classURI == null) : "Called wrong method";
    	    
		// Null entity indicates the All count
        CountResult classTotalCount = new CountResult(null, 0);
        // Compute the root class set result      
		SortedSet<CountResult> rootClasses = new TreeSet<CountResult>();
		HashMap<EIURI, CountResult> mapLabToCount = new HashMap<EIURI, CountResult>();
		for (EIEntity e : listPrimaryResources) {
        	ClassUsage usage = mapClassURIToUsage.get(e.getURI());
        	if (usage == null) {
        	    // No matches for this root class
        		continue;
        	}
            rootClasses.add(usage.getTotalCount());
            classTotalCount.increment(usage.getTotalCount().getCount());
        }    	
		result = new ClassCountResult(request);
		result.setClassCount(classTotalCount);
		result.setSubClassCounts(rootClasses);
	    
	    return result;
    }
    
    private ClassCountResult getClassResult(SearchRequest request) {
    	ClassCountResult result;
        EIURI classURI = request.getBinding() != null ? request.getBinding().getType() : null;
    	assert (classURI != null) : "Called wrong method";

		// An individual class result
    	ClassUsage usage = mapClassURIToUsage.get(classURI);
    	if (usage == null) {
    		return null;
    	}
		result = new ClassCountResult(request);
	    result.setClassCount(usage.getTotalCount());
		
        // Super classes
		List<EIClass> superclasses = eiOntModel.getSuperClasses(classURI);
		if (superclasses != null && superclasses.size() > 0) {
			List<CountResult> superClassesCounts = new ArrayList<CountResult>(superclasses.size());
			// first element of eiOntModel.getSuperClasses() list is the immediate parent
			// we want to list them in reverse order -- root level first
			for (int i=superclasses.size()-1; i>=0; i--) {
				ClassUsage scUsage = mapClassURIToUsage.get(superclasses.get(i).getEntity().getURI());
			    superClassesCounts.add(scUsage.getTotalCount());
			}
			result.setSuperClassCounts(superClassesCounts);
		}
		
		// Sub classes
		Set<EIURI> setSubClassURIs = usage.getSubClassUsages();
		if (setSubClassURIs != null && setSubClassURIs.size() > 0) {
			TreeSet<CountResult> subClassCounts = new TreeSet<CountResult>();
			for (EIURI subClassURI : setSubClassURIs) {
				ClassUsage scUsage = mapClassURIToUsage.get(subClassURI);
			    subClassCounts.add(scUsage.getTotalCount());
			}
			result.setSubClassCounts(subClassCounts);
		}
		
        return result;
    }
    
}
