/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.lucene.LuceneGenerator;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.services.InstitutionRegistry;

public final class LuceneSearchProviderFactory {
    public static LuceneSearchProvider createProviderForGeneratedData(InstitutionRegistry institutionRegistry, EIOntModel eagleiOntModel, DataGenParams datagenParams, LuceneSearchProviderIndexer indexer) throws IOException {
        LuceneGenerator generator = new LuceneGenerator(eagleiOntModel, indexer);
        if (datagenParams == null) {
            generator.generate(LuceneSearchProviderFactory.getDefaultDataGenParams(institutionRegistry));
        } else {
            generator.generate(datagenParams);
        }
        Directory dir = indexer.getDirectory();
        Analyzer analyzer = indexer.getAnalyzer();
        return new LuceneSearchProvider(eagleiOntModel, dir, analyzer);
    }

    private static DataGenParams getDefaultDataGenParams(InstitutionRegistry institutionRegistry) {
        DataGenParams params = DataGenParams.createForAllInstitutions((List)institutionRegistry.getInstitutions());
        params.setCoreFacilityRange(1, 3);
        params.setResearchFacilityRange(0, 0);
        params.setMaterializeHierarchy(true);
        return params;
    }
}

