/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.harvest;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;

public abstract class AbstractStreamHarvester
implements PollingDataHarvester {
    private static final Log logger = LogFactory.getLog(AbstractStreamHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String SUBJECT = "subject";
    private static final String PREDICATE = "predicate";
    private static final String OBJECT = "object";
    protected static final DateFormat formatWithTZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");
    protected final EIOntModel eiOntModel;
    protected final EIEntity institution;
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();
    private final Set<String> labelURIs;
    private final Set<EIURI> resourceProviderProperties;
    protected boolean isInitialized;
    private boolean isInitialPollComplete = false;
    private DataHarvestPoller pollingThread;

    protected AbstractStreamHarvester(EIOntModel eiOntModel, EIEntity institution) {
        this.eiOntModel = eiOntModel;
        this.institution = institution;
        List preferredLabelProperties = ((JenaEIOntModel)eiOntModel).getPrefLabelProperties();
        this.labelURIs = new HashSet<String>();
        for (Property prop : preferredLabelProperties) {
            this.labelURIs.add(prop.getURI());
        }
        this.resourceProviderProperties = eiOntModel.getResourceProviderProperties();
        this.setInitialized(false);
    }

    public boolean isInitialPollComplete() {
        return this.isInitialPollComplete;
    }

    public synchronized void startPolling() {
        if (this.pollingThread != null) {
            return;
        }
        this.pollingThread = new DataHarvestPoller();
        this.pollingThread.start();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public abstract String getHarvestInfo();

    public void addChangeListener(ResourceChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyChangeStreamStart() {
        for (ResourceChangeListener listener : this.listeners) {
            listener.onChangeStreamStart(this.institution);
        }
    }

    protected void notifyChangeEvent(ResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        for (ResourceChangeListener listener : this.listeners) {
            listener.onChangeEvent(event);
        }
    }

    protected void notifyChangeStreamEnd(Date lastModifiedDate) {
        for (ResourceChangeListener listener : this.listeners) {
            listener.onChangeStreamEnd(this.institution, lastModifiedDate);
        }
    }

    protected int generateResourceChangeEvents(InputStream is) {
        int count = 0;
        String currentURI = null;
        Model model = null;
        ResultSet resultSet = ResultSetFactory.fromXML((InputStream)is);
        while (resultSet.hasNext()) {
            QuerySolution soln = resultSet.next();
            Resource resource = soln.getResource(SUBJECT);
            String nextURI = resource.getURI();
            if (currentURI == null) {
                currentURI = nextURI;
                model = ModelFactory.createDefaultModel();
            } else if (!currentURI.equals(nextURI)) {
                this.notifyChangeEvent(this.createChangeEventFromModel(currentURI, model));
                ++count;
                currentURI = nextURI;
                model = ModelFactory.createDefaultModel();
            }
            Resource property = soln.getResource(PREDICATE);
            RDFNode value = soln.get(OBJECT);
            Property predicate = model.createProperty(property.getURI());
            model.add(model.createStatement(resource, predicate, value));
        }
        if (currentURI != null) {
            this.notifyChangeEvent(this.createChangeEventFromModel(currentURI, model));
            ++count;
        }
        return count;
    }

    private ResourceChangeEvent createChangeEventFromModel(String uri, Model model) {
        Statement s;
        Resource resource = model.getResource(uri);
        Property isDeleted = model.getProperty("http://eagle-i.org/ont/repo/1.0/isDeleted");
        if (isDeleted != null && (s = resource.getProperty(isDeleted)) != null && s.getObject().isLiteral() && ((Literal)s.getObject()).getBoolean()) {
            EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)resource.getURI()), (String)resource.getLocalName());
            ResourceChangeEvent result = new ResourceChangeEvent("http://eagle-i.org/ont/repo/1.0/isDeleted", entity);
            result.setEntity(entity);
            result.setInstitution(this.institution);
            return result;
        }
        Statement labelStmt = resource.getProperty(RDFS.label);
        String label = null;
        if (labelStmt != null) {
            label = labelStmt.getLiteral().getLexicalForm();
        }
        if (label == null) {
            logger.error((Object)("Resource " + resource.getURI() + " is missing label"));
            return null;
        }
        EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)resource.getURI()), (String)label);
        ResourceChangeEvent result = new ResourceChangeEvent(null, entity);
        result.setInstitution(this.institution);
        Statement type = resource.getProperty(RDF.type);
        String typeURIStr = null;
        if (type != null) {
            typeURIStr = ((Resource)type.getObject()).getURI();
        }
        if (typeURIStr == null) {
            logger.error((Object)(entity.toString() + " is missing type"));
            return null;
        }
        EIURI typeURI = EIURI.create(typeURIStr);
        if (!this.eiOntModel.isModelClassURI(typeURIStr)) {
            logger.error((Object)(entity.toString() + " has type " + typeURIStr + " that does not exist in eagle-i data model"));
            return null;
        }
        EIClass typeClass = this.eiOntModel.getClass(typeURI);
        assert (typeClass != null);
        EIEntity typeEntity = typeClass.getEntity();
        result.setType(typeEntity);
        for (EIProperty eiProp : this.eiOntModel.getProperties(typeURI)) {
            EIURI eiURI = eiProp.getEntity().getURI();
            Property modelProp = model.getProperty(eiURI.toString());
            if (modelProp == null) continue;
            for (RDFNode object : model.listObjectsOfProperty(modelProp).toList()) {
                if (eiProp instanceof EIDatatypeProperty) {
                    if (!(object instanceof Literal)) {
                        logger.error((Object)(entity.toString() + " of type " + typeEntity.toString() + " has datatype property " + eiProp.toString() + " with non-Literal value: " + object.toString()));
                        continue;
                    }
                    result.addDataTypeProperty((EIDatatypeProperty)eiProp, ((Literal)object).getLexicalForm());
                    continue;
                }
                if (!(object instanceof Resource)) {
                    logger.error((Object)(entity.toString() + " of type " + typeEntity.toString() + " has object property " + eiProp.toString() + " with non-Resource value: " + object.toString()));
                    continue;
                }
                Resource value = (Resource)object;
                EIURI valueURI = EIURI.create((String)value.getURI());
                if (this.resourceProviderProperties.contains(eiURI)) {
                    result.setProvider(valueURI);
                    continue;
                }
                result.addObjectProperty((EIObjectProperty)eiProp, valueURI);
            }
        }
        return result;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }

    private class DataHarvestPoller
    extends Thread {
        DataHarvestPoller() {
            super("DataHarvestPoller");
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    AbstractStreamHarvester.this.harvest();
                }
                catch (Throwable t) {
                    logger.error((Object)"Unexpected error during harvest", t);
                }
                AbstractStreamHarvester.this.isInitialPollComplete = true;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

