/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.search.ClassUsage;

public class ClassUsageCache {
    private static final Log logger = LogFactory.getLog(ClassUsageCache.class);
    private final EIOntModel eiOntModel;
    private HashMap<EIURI, ClassUsage> mapClassURIToUsage = new HashMap();
    private final List<EIEntity> listPrimaryResources;

    public ClassUsageCache(EIOntModel eiOntModel) {
        this.eiOntModel = eiOntModel;
        List listDataModelCreateResources = eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate");
        this.listPrimaryResources = new ArrayList<EIEntity>(listDataModelCreateResources.size() + 1);
        for (EIClass c : listDataModelCreateResources) {
            this.listPrimaryResources.add(c.getEntity());
        }
        EIClass coreResource = eiOntModel.getClass(EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000002"));
        this.listPrimaryResources.add(coreResource.getEntity());
    }

    void removeUsage(EIEntity resourceTypeEntity, EIEntity subclassTypeEntity, ResourceChangeEvent event) {
        ClassUsage classUsage = this.mapClassURIToUsage.get(resourceTypeEntity.getURI());
        assert (classUsage != null) : "removeUsage called for a type that had no usage previously recorded: " + resourceTypeEntity + "  instance: " + event.getEntity();
        classUsage.decrementUsage();
        if (classUsage.getTotalCount().getCount() == 0) {
            this.mapClassURIToUsage.remove(resourceTypeEntity.getURI());
        } else if (subclassTypeEntity != null) {
            classUsage.removeSubClassUsage(subclassTypeEntity.getURI());
        }
        EIClass resourceClass = this.eiOntModel.getClass(resourceTypeEntity.getURI());
        EIClass resourceSuperClass = this.eiOntModel.getSuperClass(resourceClass);
        if (resourceSuperClass != null) {
            this.removeUsage(resourceSuperClass.getEntity(), (EIEntity)(classUsage.getTotalCount().getCount() == 0 ? resourceTypeEntity : null), event);
        }
    }

    void addUsage(EIEntity resourceTypeEntity, EIEntity subclassTypeEntity, ResourceChangeEvent event) {
        EIClass resourceClass;
        EIClass resourceSuperClass;
        ClassUsage classUsage = this.mapClassURIToUsage.get(resourceTypeEntity.getURI());
        if (classUsage == null) {
            classUsage = new ClassUsage(resourceTypeEntity);
            this.mapClassURIToUsage.put(resourceTypeEntity.getURI(), classUsage);
        }
        classUsage.incrementUsage();
        if (subclassTypeEntity != null) {
            classUsage.addSubClassUsage(subclassTypeEntity.getURI());
        }
        if ((resourceSuperClass = this.eiOntModel.getSuperClass(resourceClass = this.eiOntModel.getClass(resourceTypeEntity.getURI()))) != null) {
            this.addUsage(resourceSuperClass.getEntity(), resourceTypeEntity, event);
        }
    }

    public ClassCountResult getClassCount(SearchRequest request) {
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        if (classURI == null) {
            return this.getPrimaryResourcesResult(request);
        }
        return this.getClassResult(request);
    }

    private ClassCountResult getPrimaryResourcesResult(SearchRequest request) {
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        assert (classURI == null) : "Called wrong method";
        CountResult classTotalCount = new CountResult(null, 0);
        TreeSet<CountResult> rootClasses = new TreeSet<CountResult>();
        HashMap mapLabToCount = new HashMap();
        for (EIEntity e : this.listPrimaryResources) {
            ClassUsage usage = this.mapClassURIToUsage.get(e.getURI());
            if (usage == null) continue;
            rootClasses.add(usage.getTotalCount());
            classTotalCount.increment(usage.getTotalCount().getCount().intValue());
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(classTotalCount);
        result.setSubClassCounts(rootClasses);
        return result;
    }

    private ClassCountResult getClassResult(SearchRequest request) {
        Set<EIURI> setSubClassURIs;
        EIURI classURI;
        EIURI eIURI = classURI = request.getBinding() != null ? request.getBinding().getType() : null;
        assert (classURI != null) : "Called wrong method";
        ClassUsage usage = this.mapClassURIToUsage.get(classURI);
        if (usage == null) {
            return null;
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(usage.getTotalCount());
        List superclasses = this.eiOntModel.getSuperClasses(classURI);
        if (superclasses != null && superclasses.size() > 0) {
            ArrayList<CountResult> superClassesCounts = new ArrayList<CountResult>(superclasses.size());
            for (int i = superclasses.size() - 1; i >= 0; --i) {
                ClassUsage scUsage = this.mapClassURIToUsage.get(((EIClass)superclasses.get(i)).getEntity().getURI());
                superClassesCounts.add(scUsage.getTotalCount());
            }
            result.setSuperClassCounts(superClassesCounts);
        }
        if ((setSubClassURIs = usage.getSubClassUsages()) != null && setSubClassURIs.size() > 0) {
            TreeSet<CountResult> subClassCounts = new TreeSet<CountResult>();
            for (EIURI subClassURI : setSubClassURIs) {
                ClassUsage scUsage = this.mapClassURIToUsage.get(subClassURI);
                subClassCounts.add(scUsage.getTotalCount());
            }
            result.setSubClassCounts(subClassCounts);
        }
        return result;
    }
}

