package org.eaglei.search.provider.lucene;

import org.eaglei.search.config.SearchProperties;

/**
 * Extension of SearchProperties that contains properties for the LuceneProvider.
 * @author frost 
 */
public final class LuceneSearchProviderProperties extends SearchProperties {
    
    /** 
     * System property that holds the index update frequency in msec.
     */
    public static final String UPDATE_FREQUENCY = "org.eaglei.search.provider.lucene.composite.update.freq";  
    /**
     * Default update frequency 
     */
    public static final long DEFAULT_UPDATE_FREQ = 1000*10; // every 10 seconds
    /**
     * Name of SearchConfiguration property that holds a directory on classpath where provider looks for lucene index
     */    
    public static final String LUCENE_INDEX_DIR_PROP = "org.eaglei.search.provider.lucene.index.dir";
}
