/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.harvest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.harvest.DataHarvester;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.harvest.ResourceChangeListener;

public final class MultiDataSourceStreamHarvester
implements PollingDataHarvester {
    private static final Log logger = LogFactory.getLog(MultiDataSourceStreamHarvester.class);
    private boolean isInitialPollComplete = false;
    private final List<DataHarvester> harvesters = new ArrayList<DataHarvester>();
    private MultiDataSourceHarvestPoller pollingThread;

    public void addDataHarvester(DataHarvester harvester) {
        this.harvesters.add(harvester);
    }

    public void addChangeListener(ResourceChangeListener listener) {
        for (DataHarvester harvester : this.harvesters) {
            harvester.addChangeListener(listener);
        }
    }

    public boolean isInitialPollComplete() {
        return this.isInitialPollComplete;
    }

    public void startPolling() {
        if (this.pollingThread != null) {
            return;
        }
        this.pollingThread = new MultiDataSourceHarvestPoller();
        this.pollingThread.start();
    }

    public void harvest() {
        for (DataHarvester harvester : this.harvesters) {
            harvester.harvest();
        }
    }

    private class MultiDataSourceHarvestPoller
    extends Thread {
        MultiDataSourceHarvestPoller() {
            super("MultiDataSourceHarvestPoller");
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                for (DataHarvester harvester : MultiDataSourceStreamHarvester.this.harvesters) {
                    try {
                        harvester.harvest();
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Unexpected error during harvest", t);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                MultiDataSourceStreamHarvester.this.isInitialPollComplete = true;
            }
        }
    }
}

