/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.lucene.harvest.AbstractStreamHarvester;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;

public final class RepositoryStreamHarvester
extends AbstractStreamHarvester {
    private static final Log logger = LogFactory.getLog(RepositoryStreamHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private String lastModifiedStr = null;
    private Date lastModifiedDate = null;
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");
    private final RepositoryHttpConfig repoConfig;
    private HttpClient httpclient;

    public RepositoryStreamHarvester(EIOntModel eiOntModel, EIEntity institution, InstitutionRegistry institutionRegistry) {
        super(eiOntModel, institution);
        this.repoConfig = institutionRegistry.getRepositoryHttpConfig(institution.getURI().toString());
        this.httpclient = RepositoryHttpConfig.createHttpClient((String)this.repoConfig.getSearchUsername(), (String)this.repoConfig.getSearchPassword());
        this.httpclient.setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager(false));
        if (DEBUG) {
            logger.debug((Object)("Created repository harvester for " + institution.getLabel() + " url: " + this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.HARVEST_URL)));
        }
    }

    @Override
    public String getHarvestInfo() {
        String harvestUrl = this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.HARVEST_URL);
        if (this.lastModifiedDate != null) {
            return "Dataset:   " + formatWithTZ.format(this.lastModifiedDate) + "    [" + harvestUrl + "]";
        }
        return harvestUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void harvest() {
        PostMethod method = new PostMethod(this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.HARVEST_URL));
        method.setParameter("view", "published-resources");
        method.setParameter("detail", "full");
        if (this.lastModifiedDate != null) {
            method.setParameter("after", format.format(this.lastModifiedDate) + "Z");
        }
        InputStream is = null;
        Reader in = null;
        Object fw = null;
        try {
            long startTime = System.currentTimeMillis();
            int status = this.httpclient.executeMethod((HttpMethod)method);
            if (status != 200) {
                if (status == 401) {
                    logger.warn((Object)"harvest request status: Unauthorized");
                    return;
                }
                String response = ProviderUtils.getStringFromInputStream((InputStream)method.getResponseBodyAsStream());
                logger.error((Object)("harvest failed with status: " + status + "\r\n" + response));
                return;
            }
            String newLastModifiedStr = method.getResponseHeader("X-Precise-Last-Modified").getValue();
            if (newLastModifiedStr.equals(this.lastModifiedStr)) {
                return;
            }
            this.lastModifiedStr = newLastModifiedStr;
            this.notifyChangeStreamStart();
            is = method.getResponseBodyAsStream();
            int count = this.generateResourceChangeEvents(is);
            try {
                this.lastModifiedDate = preciseHTTPDate.parse(this.lastModifiedStr);
            }
            catch (ParseException e) {
                logger.error((Object)("Error parsing X-Precise-Last-Modified " + this.lastModifiedStr));
            }
            this.notifyChangeStreamEnd(this.lastModifiedDate);
            return;
        }
        catch (IOException e) {
            logger.debug((Object)("Unexpected error in RepositoryStreamHarvester " + this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.HARVEST_URL)), (Throwable)e);
            return;
        }
        finally {
            method.releaseConnection();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (fw != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }
}

