/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.search;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.search.provider.lucene.AbstractLuceneIndexer;
import org.eaglei.search.provider.lucene.search.ClassUsageCache;
import org.eaglei.search.provider.lucene.search.LuceneSearchIndexSchema;
import org.eaglei.search.provider.lucene.search.LuceneSearchUtil;

public final class LuceneSearchIndexer
extends AbstractLuceneIndexer
implements LuceneSearchIndexSchema,
ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(LuceneSearchIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private Set<EIURI> flattenTypeURIs = new HashSet<EIURI>();
    private Set<EIURI> skipPropTextIndexing = new HashSet<EIURI>();
    private Map<EIURI, Float> mapTypeToBoost = new HashMap<EIURI, Float>();
    private Set<EIURI> unresolvedInstanceRefs = new HashSet<EIURI>();
    private Set<EIURI> flattenInstancesWithNoRefs = new HashSet<EIURI>();
    private ClassUsageCache classUsageCache;

    public LuceneSearchIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory, ClassUsageCache classUsageCache) {
        super(eiOntModel, analyzer, directory);
        this.classUsageCache = classUsageCache;
        this.initBoostMap();
        this.initFlattenCache();
        this.skipPropTextIndexing.add(EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000480"));
    }

    private void initBoostMap() {
        this.mapTypeToBoost.put(EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0000245"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create((String)"http://vivoweb.org/ontology/core#PrivateCompany"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create((String)"http://purl.obolibrary.org/obo/IAO_0000310"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create((String)"http://purl.obolibrary.org/obo/IAO_0000311"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create((String)"http://xmlns.com/foaf/0.1/Person"), Float.valueOf(0.5f));
        this.mapTypeToBoost.put(EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0000272"), Float.valueOf(0.8f));
    }

    private void initFlattenCache() {
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class")) {
            this.addFlattenClass(c);
        }
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_SearchFlatten")) {
            this.addFlattenClass(c);
        }
    }

    private void addFlattenClass(EIClass c) {
        this.flattenTypeURIs.add(c.getEntity().getURI());
        for (EIClass sub : this.eiOntModel.getSubClasses(c.getEntity().getURI())) {
            this.flattenTypeURIs.add(sub.getEntity().getURI());
        }
    }

    private boolean isFlattenClass(EIURI uri) {
        return this.flattenTypeURIs.contains(uri);
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        super.onChangeEvent(event);
        if (event.isDelete()) {
            this.deleteResourceInstance(event);
        } else if (this.isFlattenClass(event.getType().getURI())) {
            this.indexFlattenClass(event);
        } else {
            this.indexResourceInstance(event);
        }
    }

    @Override
    public void onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        if (this.unresolvedInstanceRefs.size() > 0) {
            logger.warn((Object)("Unresolved instance references in search index:  num: " + this.unresolvedInstanceRefs.size()));
        }
        if (this.flattenInstancesWithNoRefs.size() > 0) {
            logger.warn((Object)("Flatten instance URIs with no referring instance:  num: " + this.flattenInstancesWithNoRefs.size()));
        }
        super.onChangeStreamEnd(institution, lastModifiedDate);
    }

    private void deleteResourceInstance(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        EIEntity typeEntity = null;
        Field[] referencedByFields = null;
        List<Document> previousVersions = this.getDocuments(uri);
        String previousLabel = null;
        if (previousVersions != null && previousVersions.size() > 0) {
            previousLabel = previousVersions.get(0).get("entity_label");
            referencedByFields = previousVersions.get(0).getFields("referenced_by");
            String typeLabel = previousVersions.get(0).get("asserted_type_label");
            String typeURIStr = previousVersions.get(0).get("asserted_type_uri");
            if (typeURIStr != null && typeLabel != null) {
                typeEntity = EIEntity.create((String)typeURIStr, (String)typeLabel);
            } else {
                logger.warn((Object)("Unexpected: LuceneSearchIndexer.deleteResourceInstance(): deleting previous version of resource, but it doesn't have type fields: " + event.getEntity()));
            }
        }
        if (referencedByFields != null) {
            for (void var10_11 : referencedByFields) {
                this.updateReferencingDocument(EIURI.create((String)var10_11.stringValue()), uri.toString(), null, previousLabel);
            }
        }
        this.deleteDocuments(uri);
        if (typeEntity != null) {
            this.classUsageCache.removeUsage(typeEntity, null, event);
        }
    }

    private void indexFlattenClass(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        List<Document> referencingDocuments = this.getReferencingDocuments(uri);
        if (referencingDocuments == null || referencingDocuments.size() == 0) {
            logger.error((Object)("No referencing documents found for flatten instance event: " + event.getEntity()));
            this.flattenInstancesWithNoRefs.add(uri);
            return;
        }
        this.updateReferencingDocument(referencingDocuments, uri.toString(), event.getEntity().getLabel(), null);
        for (Document refDoc : referencingDocuments) {
            this.addProperties(refDoc, event, true);
        }
        List<Document> docs = this.getDocuments(uri);
        if (docs == null) {
            logger.error((Object)("No document indexed for flatten doc: " + event.getEntity()));
            return;
        }
        for (Document doc : docs) {
            doc.removeFields("referenced_by");
        }
        this.deleteDocuments(uri);
        this.unresolvedInstanceRefs.remove(uri);
    }

    private List<Document> indexResourceInstance(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        Document doc = new Document();
        String previousLabel = null;
        Field[] referencedByFields = null;
        List<Document> previousVersions = this.getDocuments(uri);
        if (previousVersions != null && previousVersions.size() > 0) {
            previousLabel = previousVersions.get(0).get("entity_label");
            referencedByFields = previousVersions.get(0).getFields("referenced_by");
            if (referencedByFields != null) {
                for (Field f : referencedByFields) {
                    doc.add((Fieldable)f);
                }
            }
        }
        Field field = new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(1000.0f);
        doc.add((Fieldable)field);
        String label = event.getEntity().getLabel();
        field = new Field("entity_label", label, Field.Store.YES, Field.Index.NO);
        doc.add((Fieldable)field);
        field = new Field("label", label, Field.Store.YES, Field.Index.ANALYZED);
        field.setBoost(1.4f);
        doc.add((Fieldable)field);
        if (event.getInstitution() != null) {
            String institutionURI = event.getInstitution().getURI().toString();
            doc.add((Fieldable)new Field("institution_uri", institutionURI, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        field = new Field("asserted_type_uri", event.getType().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(8.0f);
        doc.add((Fieldable)field);
        field = new Field("asserted_type_label", event.getType().getLabel(), Field.Store.YES, Field.Index.ANALYZED);
        field.setBoost(2.0f);
        doc.add((Fieldable)field);
        for (EIClass superclass : this.eiOntModel.getSuperClasses(event.getType().getURI())) {
            field = new Field("inferred_type_uri", superclass.getEntity().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            field.setBoost(7.0f);
            doc.add((Fieldable)field);
            field = new Field("inferred_type_label", superclass.getEntity().getLabel(), Field.Store.YES, Field.Index.ANALYZED);
            field.setBoost(1.8f);
            doc.add((Fieldable)field);
        }
        this.addProperties(doc, event, false);
        Float documentBoost = this.mapTypeToBoost.get(uri);
        if (documentBoost != null) {
            doc.setBoost(documentBoost.floatValue());
        }
        ArrayList<Document> docs = new ArrayList<Document>(1);
        docs.add(doc);
        this.setDocuments(event.getEntity().getURI(), docs);
        this.unresolvedInstanceRefs.remove(uri);
        this.classUsageCache.addUsage(event.getType(), null, event);
        if (referencedByFields != null && !label.equals(previousLabel)) {
            for (Field f : referencedByFields) {
                this.updateReferencingDocument(EIURI.create((String)f.stringValue()), uri.toString(), label, previousLabel);
            }
        }
        return docs;
    }

    private void addProperties(Document doc, ResourceChangeEvent event, boolean isFlattenClassEvent) {
        if (!isFlattenClassEvent && event.getProvider() != null) {
            this.setResourceProvider(doc, event.getProvider());
        }
        for (EIDatatypeProperty prop : event.getDataTypeProperties()) {
            if (this.skipPropTextIndexing.contains(prop.getEntity().getURI())) continue;
            for (String valueLabel : event.getDataTypeProperty(prop)) {
                this.addDatatypePropertyTextField(doc, prop, valueLabel);
            }
        }
        for (EIDatatypeProperty prop : event.getObjectProperties()) {
            for (EIURI valueURI : event.getObjectProperty((EIObjectProperty)prop)) {
                String valueLabel;
                Field entityLabelField;
                Field field = new Field("prop_uri", valueURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                field.setBoost(7.0f);
                doc.add((Fieldable)field);
                if (this.eiOntModel.isModelClassURI(valueURI.toString())) {
                    EIClass valueEIClass = this.eiOntModel.getClass(valueURI);
                    this.addObjectPropertyTextField(doc, (EIObjectProperty)prop, valueURI, valueEIClass.getEntity().getLabel());
                    continue;
                }
                List<Document> valueDocuments = this.getDocuments(valueURI);
                if (valueDocuments != null && valueDocuments.size() > 0 && (entityLabelField = valueDocuments.get(0).getField("entity_label")) != null && (valueLabel = entityLabelField.stringValue()) != null) {
                    this.addObjectPropertyTextField(doc, (EIObjectProperty)prop, valueURI, valueLabel);
                }
                this.setReferencingDocument(event.getEntity().getURI(), valueURI);
            }
        }
    }

    private void addDatatypePropertyTextField(Document doc, EIDatatypeProperty prop, String valueLabel) {
        String propFieldName = LuceneSearchUtil.getPropertyFieldName(prop.getEntity(), null);
        this.addPropertyTextField(doc, propFieldName, valueLabel);
    }

    private void addObjectPropertyTextField(Document doc, EIObjectProperty prop, EIURI valueURI, String valueLabel) {
        String propFieldName = LuceneSearchUtil.getPropertyFieldName(prop.getEntity(), valueURI.toString());
        this.addPropertyTextField(doc, propFieldName, valueLabel);
    }

    private void addPropertyTextField(Document doc, String propFieldName, String valueLabel) {
        Field field = new Field(propFieldName, valueLabel, Field.Store.YES, Field.Index.ANALYZED);
        doc.add((Fieldable)field);
        this.addPropertyTextField(doc, valueLabel);
    }

    private void addPropertyTextField(Document doc, String valueLabel) {
        Field field = new Field("prop_text", valueLabel, Field.Store.YES, Field.Index.ANALYZED);
        field.setBoost(1.2f);
        doc.add((Fieldable)field);
    }

    private void updateReferencingDocument(EIURI referencingURI, String valueURIStr, String valueLabel, String previousValueLabel) {
        List<Document> docs = this.getDocuments(referencingURI);
        if (docs == null || docs.size() == 0) {
            logger.error((Object)("No Document found for " + referencingURI + " which is expected to reference: " + valueLabel + " : " + valueURIStr));
            return;
        }
        this.updateReferencingDocument(docs, valueURIStr, valueLabel, previousValueLabel);
    }

    private void updateReferencingDocument(List<Document> docs, String valueURIStr, String valueLabel, String previousValueLabel) {
        for (Document doc : docs) {
            String providerURIStr = doc.get("provider_uri");
            if (providerURIStr != null && providerURIStr.equals(valueURIStr)) {
                doc.removeFields("provider_uri");
                this.setResourceProvider(doc, EIURI.create((String)providerURIStr));
            }
            doc.removeFields("prop_text");
            HashMap<String, String> mapPropFieldNameToValue = new HashMap<String, String>();
            for (Fieldable fieldable : doc.getFields()) {
                String fieldName = fieldable.name();
                if (!fieldable.isTokenized()) continue;
                String someValueURIStr = LuceneSearchUtil.getPropertyValueURIString(fieldName);
                if (valueURIStr.equals(someValueURIStr)) {
                    if (valueLabel == null) continue;
                    mapPropFieldNameToValue.put(fieldName, valueLabel);
                    continue;
                }
                if (!fieldName.startsWith(LuceneSearchUtil.DATATYPE_PROP_FIELD_PREFIX) && !fieldName.startsWith(LuceneSearchUtil.OBJECT_PROP_FIELD_PREFIX)) continue;
                mapPropFieldNameToValue.put(fieldName, fieldable.stringValue());
            }
            for (Map.Entry entry : mapPropFieldNameToValue.entrySet()) {
                doc.removeFields((String)entry.getKey());
                this.addPropertyTextField(doc, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void setReferencingDocument(EIURI referencedBy, EIURI referenced) {
        List<Document> referencedDocuments = this.getDocuments(referenced);
        if (referencedDocuments == null || referencedDocuments.size() == 0) {
            Document stubDoc = this.createStubInstance(referenced);
            this.setReferencingDocument(referencedBy, stubDoc);
        } else {
            for (Document referencedDoc : referencedDocuments) {
                this.setReferencingDocument(referencedBy, referencedDoc);
            }
        }
    }

    private void setReferencingDocument(EIURI referencedBy, Document referenced) {
        Field field = new Field("referenced_by", referencedBy.toString(), Field.Store.YES, Field.Index.NO);
        referenced.add((Fieldable)field);
    }

    private List<Document> getReferencingDocuments(EIURI uri) {
        ArrayList<Document> result = new ArrayList<Document>();
        List<Document> docs = this.getDocuments(uri);
        if (docs != null && docs.size() > 0) {
            for (String refDocURI : docs.get(0).getValues("referenced_by")) {
                List<Document> refDocs = this.getDocuments(EIURI.create((String)refDocURI));
                if (refDocs == null) continue;
                result.addAll(refDocs);
            }
        }
        return result;
    }

    private Document createStubInstance(EIURI uri) {
        Document doc = new Document();
        Field field = new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        ArrayList<Document> docs = new ArrayList<Document>(1);
        docs.add(doc);
        this.setDocuments(uri, docs);
        this.unresolvedInstanceRefs.add(uri);
        return doc;
    }

    private void setResourceProvider(Document doc, EIURI providerURI) {
        List<Document> providerDocuments = this.getDocuments(providerURI);
        if (providerDocuments != null && providerDocuments.size() > 0) {
            Field field = new Field("provider_uri", providerURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)field);
            Document providerDoc = providerDocuments.get(0);
            String providerLabel = providerDoc.get("entity_label");
            if (providerLabel != null) {
                field = new Field("provider_label", providerLabel, Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add((Fieldable)field);
                String providerAssertedTypeURI = providerDoc.get("asserted_type_uri");
                field = new Field("provider_type_uri", providerAssertedTypeURI, Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add((Fieldable)field);
                for (Field f : providerDoc.getFields("inferred_type_uri")) {
                    String providerInferredTypeURI = f.stringValue();
                    field = new Field("provider_type_uri", providerInferredTypeURI, Field.Store.YES, Field.Index.NOT_ANALYZED);
                    doc.add((Fieldable)field);
                }
            }
        }
    }
}

