/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene.search;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.search.LuceneSearchIndexSchema;

public final class LuceneSearchQueryBuilder
implements LuceneSearchIndexSchema {
    private static final Log logger = LogFactory.getLog(LuceneSearchQueryBuilder.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final EIOntModel eagleiOntModel;
    private Analyzer analyzer;
    private QueryParser labelParser;
    private QueryParser propTextParser;
    private QueryParser inferredTypeLabelParser;
    private QueryParser assertedTypeLabelParser;

    public LuceneSearchQueryBuilder(EIOntModel eagleiOntModel, Analyzer analyzer) {
        assert (eagleiOntModel != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.analyzer = analyzer;
        this.labelParser = new QueryParser(Version.LUCENE_30, "label", this.analyzer);
        this.propTextParser = new QueryParser(Version.LUCENE_30, "prop_text", this.analyzer);
        this.inferredTypeLabelParser = new QueryParser(Version.LUCENE_30, "inferred_type_label", this.analyzer);
        this.assertedTypeLabelParser = new QueryParser(Version.LUCENE_30, "asserted_type_label", this.analyzer);
    }

    public Query createQuery(SearchRequest request) throws ParseException {
        EIURI typeURI;
        SearchRequest.Term term = request.getTerm();
        BooleanQuery query = new BooleanQuery();
        if (request.getLocation() != null) {
            if (request.getLocation().getInstitution() != null) {
                PhraseQuery institutionQuery = new PhraseQuery();
                institutionQuery.add(new Term("institution_uri", request.getLocation().getInstitution().toString()));
                query.add((Query)institutionQuery, BooleanClause.Occur.MUST);
            }
            if (request.getLocation().getURI() != null) {
                if (request.getBinding() != null) {
                    EIURI providerPropertyURI = this.eagleiOntModel.getResourceProviderProperty(request.getBinding().getType());
                    if (providerPropertyURI == null) {
                        logger.error((Object)("Unable to compute a resource provider property for request type binding: " + request.getBinding().getType()));
                    } else {
                        PhraseQuery propQuery = new PhraseQuery();
                        propQuery.add(new Term(providerPropertyURI.toString(), request.getLocation().getURI().toString()));
                        query.add((Query)propQuery, BooleanClause.Occur.MUST);
                    }
                } else {
                    BooleanQuery providerQuery = new BooleanQuery();
                    query.add((Query)providerQuery, BooleanClause.Occur.MUST);
                    String providerValue = request.getLocation().getURI().toString();
                    for (EIURI providerPropertyURI : this.eagleiOntModel.getResourceProviderProperties()) {
                        PhraseQuery propQuery = new PhraseQuery();
                        propQuery.add(new Term(providerPropertyURI.toString(), providerValue));
                        providerQuery.add((Query)propQuery, BooleanClause.Occur.SHOULD);
                    }
                }
            }
        }
        if (term != null) {
            BooleanQuery termQuery = new BooleanQuery();
            query.add((Query)termQuery, BooleanClause.Occur.MUST);
            if (term.getURI() != null) {
                EIURI uri = term.getURI();
                if (this.eagleiOntModel.isModelClassURI(uri.toString())) {
                    PhraseQuery typeQuery = new PhraseQuery();
                    typeQuery.add(new Term("asserted_type_uri", uri.toString()));
                    termQuery.add((Query)typeQuery, BooleanClause.Occur.SHOULD);
                    typeQuery = new PhraseQuery();
                    typeQuery.add(new Term("inferred_type_uri", uri.toString()));
                    termQuery.add((Query)typeQuery, BooleanClause.Occur.SHOULD);
                    Iterator i$ = this.eagleiOntModel.getLabels(uri).iterator();
                    while (i$.hasNext()) {
                        String label;
                        boolean isQueryLabel = (label = (String)i$.next()).equals(term.getQuery());
                        this.addLabelQuery(termQuery, label, !isQueryLabel);
                    }
                } else {
                    PhraseQuery uriQuery = new PhraseQuery();
                    uriQuery.add(new Term("uri", uri.toString()));
                    termQuery.add((Query)uriQuery, BooleanClause.Occur.SHOULD);
                    this.addLabelQuery(termQuery, term.getQuery(), false);
                }
                PhraseQuery propQuery = new PhraseQuery();
                propQuery.add(new Term("prop_uri", uri.toString()));
                termQuery.add((Query)propQuery, BooleanClause.Occur.SHOULD);
            } else if (term.getQuery() != null) {
                Query textQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.labelParser, (String)term.getQuery());
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.assertedTypeLabelParser, (String)term.getQuery());
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.inferredTypeLabelParser, (String)term.getQuery());
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.propTextParser, (String)term.getQuery());
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
            }
        }
        if ((typeURI = SearchProviderUtil.getType((SearchRequest)request)) != null) {
            BooleanQuery typeQuery = new BooleanQuery();
            query.add((Query)typeQuery, BooleanClause.Occur.MUST);
            PhraseQuery assertedType = new PhraseQuery();
            assertedType.add(new Term("asserted_type_uri", typeURI.toString()));
            typeQuery.add((Query)assertedType, BooleanClause.Occur.SHOULD);
            PhraseQuery inferredType = new PhraseQuery();
            inferredType.add(new Term("inferred_type_uri", typeURI.toString()));
            typeQuery.add((Query)inferredType, BooleanClause.Occur.SHOULD);
        }
        if (query.clauses().isEmpty()) {
            MatchAllDocsQuery allDocsQuery = new MatchAllDocsQuery();
            query.add((Query)allDocsQuery, BooleanClause.Occur.MUST);
            return query;
        }
        return query;
    }

    private void addLabelQuery(BooleanQuery termQuery, String label, boolean isSynonym) {
        try {
            String phraseQueryStr = "\"" + label + "\"";
            Query labelQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.labelParser, (String)phraseQueryStr);
            if (isSynonym) {
                labelQuery.setBoost(0.8f);
            }
            termQuery.add(labelQuery, BooleanClause.Occur.SHOULD);
            labelQuery = LuceneUtils.escapeIfInvalid((QueryParser)this.propTextParser, (String)phraseQueryStr);
            if (isSynonym) {
                labelQuery.setBoost(0.8f);
            }
            termQuery.add(labelQuery, BooleanClause.Occur.SHOULD);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

