/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.gene;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBIEUtils;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.gene.NCBIGeneProvider;
import org.eaglei.services.InstitutionRegistry;

public final class NCBIGeneSearchProvider
extends NCBISearchProvider {
    private static final Log logger = LogFactory.getLog(NCBIGeneSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String GENE_URI = "http://purl.obolibrary.org/obo/ERO_0000223";
    private final EIEntity entrezGeneEntity;
    private final EIEntity geneEntity;
    private final EIEntity locationEntity;

    public NCBIGeneSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        super((NCBIDBProvider)new NCBIGeneProvider(), eagleiOntModel, registry);
        this.geneEntity = eagleiOntModel.getClass(EIURI.create((String)GENE_URI)).getEntity();
        this.entrezGeneEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/gene/"), (String)"Entrez Gene");
        this.locationEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/gene/"), (String)"NCBI Entrez Gene");
    }

    @Override
    public EIEntity getType() {
        return this.entrezGeneEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request) throws IOException {
        return true;
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(NCBIEUtils.DocSummary sum) throws IOException {
        NCBIGeneProvider.GeneSummary geneSum = new NCBIGeneProvider.GeneSummary(sum);
        SearchResult searchResult = new SearchResult(EIEntity.create((String)geneSum.url, (String)geneSum.label), this.entrezGeneEntity, null, this.locationEntity);
        searchResult.setURL(geneSum.url);
        searchResult.setHighlight(geneSum.orgname.value + ": " + geneSum.desc.value);
        return searchResult;
    }

    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, false, Collections.EMPTY_SET, false);
    }
}

